package com.bcxin.ins.models.order.policy.service.impl;


import com.bcxin.ins.entity.policy_special.SpecialBid;
import com.bcxin.ins.models.order.policy.dao.SpecialBidDao;
import com.bcxin.ins.models.order.policy.service.SpecialBidService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.SpecialBidVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


/**
 * <b>小微企业特殊字段业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class SpecialBidServiceImpl extends ServiceImpl<SpecialBidDao, SpecialBid> implements SpecialBidService {

	@Autowired
	private SpecialBidDao dao;

	public SpecialBid initInsSpecialBid(){
		SpecialBid insSpecialBid = new SpecialBid();//
		dao.insert(insSpecialBid);
		return insSpecialBid;
	}

	/**
	 * <b>根据Vo及小微出口ID更新InsSpecialBid数据 </b>
	 *
	 * @param vo
	 * @param microID 小微出口id
	 * @author ZXF
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheSpecialBidVoSetUpInsSpecialBid(SpecialBidVo vo, Long microID){
		SpecialBid insSpecialBid = dao.selectById(microID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insSpecialBid);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insSpecialBid);
	}

	/**
	 * <b>获取SpecialBidVo根据小微出口id查询小微出口信息插入到SpecialBidVo </b>
	 *
	 * @param vo 小微出口辅助表
	 * @param microID 小微出口id
	 * @author ZXF
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void getSpecialBidVoByPolicyID(SpecialBidVo vo, Long microID){
		SpecialBid insSpecialBid = dao.selectById(microID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insSpecialBid), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
