package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.models.order.policy.dao.InsRoleInpolicyDao;
import com.bcxin.ins.models.order.policy.service.InsInsuranceSlipService;
import com.bcxin.ins.models.order.policy.service.InsRoleFavoreeService;
import com.bcxin.ins.models.order.policy.service.InsRoleInpolicyService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * <b>投保单被保人业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsRoleInpolicyServiceImpl extends ServiceImpl<InsRoleInpolicyDao, InsRoleInpolicy> implements InsRoleInpolicyService {

	@Autowired
	private InsRoleInpolicyDao dao;
	
	@Autowired
	private InsRoleFavoreeService insRoleFavoreeService;
	
	@Autowired
	private InsInsuranceSlipService insInsuranceSlipgService;
	
	/**
	 * <b>根据投保单id查询投保单被保人列表 </b> 
	 * 
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 下午4:18:19
	 * @注意事项 </b>
	 * <b>
	 */
	public List<InsRoleInpolicy> selectInsRoleInpolicyByInsInsuranceSlip(Long oid){
		List<InsRoleInpolicy> roles = dao.selectInsRoleInpolicyByInsInsuranceSlip(oid);
		List<InsRoleInpolicy> nroles = new ArrayList<>();
		for(InsRoleInpolicy iri : roles){
			nroles.add(packagingInsRoleInpolicy(iri.getIns_role_inpolicy_id()));
		}
		return nroles;
	};
	
	/**
	 * <b>根据投保人id查询相关信息 </b> 
	 * 
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 下午4:50:59
	 * @注意事项 </b>
	 * <b>
	 */
	public InsRoleInpolicy packagingInsRoleInpolicy(Long oid){
		InsRoleInpolicy insRoleInpolicy = dao.selectById(oid);
		if(insRoleInpolicy != null){
			insRoleInpolicy.setInsRoleFavoreeList(insRoleFavoreeService.selectInsRoleFavoreeByInsRoleInpolicy(insRoleInpolicy.getIns_role_inpolicy_id()));
		}
		return insRoleInpolicy;
	}
	
	/**
	 * <b>根据投保单id,投保人类型初始化投保人及相关表，相当于new InsRoleInpolicy()</b> 
	 * 
	 * @param insInsuranceSlip 投保单
	 * @param roleType 角色（个人或企业）
	 * @param kind 角色（投保人或被保人或2者）
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 下午1:42:10
	 * @注意事项 </b>
	 * <b>
	 */
	public List<InsRoleInpolicy> initInsRoleInpolicy(InsInsuranceSlip insInsuranceSlip,String roleType, String kind){
		List<InsRoleInpolicy> roleLost = new ArrayList<InsRoleInpolicy>();
		InsRoleInpolicy insRoleInpolicy = new InsRoleInpolicy();
		if(ConstProp.APPANDINS.equals(kind)){
			insRoleInpolicy.setKind(ConstProp.ROLE_APPLICANT);
			createRole(insRoleInpolicy, insInsuranceSlip, roleType);
			roleLost.add(insRoleInpolicy);
			insRoleInpolicy = new InsRoleInpolicy();
			insRoleInpolicy.setKind(ConstProp.ROLE_INSURED);
			createRole(insRoleInpolicy, insInsuranceSlip, roleType);
			roleLost.add(insRoleInpolicy);
		}else{
			insRoleInpolicy.setKind(kind);
			createRole(insRoleInpolicy, insInsuranceSlip, roleType);
			roleLost.add(insRoleInpolicy);
		}
		return roleLost;
	}
	
	public void createRole(InsRoleInpolicy insRoleInpolicy, InsInsuranceSlip insInsuranceSlip, String roleType){
		insRoleInpolicy.setRole_type(roleType);
		insRoleInpolicy.getInsurance_slip().setIns_insurance_slip_id(insInsuranceSlip.getIns_insurance_slip_id());
		dao.insert(insRoleInpolicy);
	}
	
	/**
	 * <b>接收页面传回的投保人/被保人信息列表进行更新 </b> 
	 * 
	 * @param voList 投保人/被保人信息列表
	 * @param policyID 投保单id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public void setRoleInPolicyByRoleCompanyVo(List<RoleSubjectVo> voList, Long policyID){
		if(voList == null || voList.size()<=ConstProp.INT_NUMBER_ZERO){
			return;
		}
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipgService.packagingInsInsuranceSlip(policyID);
		for(RoleSubjectVo vo : voList){
			accordingToTheRoleSubjectVoSetUpInsRoleInpolicy(vo, insInsuranceSlip);
		}
	}
	
	/**
	 * <b>根据Vo及投保单ID更新InsRoleInpolicy数据 </b> 
	 * 
	 * @param vo
	 * @param insInsuranceSlip 投保单
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheRoleSubjectVoSetUpInsRoleInpolicy(RoleSubjectVo vo,InsInsuranceSlip insInsuranceSlip){
		InsRoleInpolicy insRoleInpolicy = null;

		if(StrUtil.isNotBlank(vo.getOid())){
			if(ConstProp.APPANDINS.equals(vo.getKind())){
				List<InsRoleInpolicy> roleList = selectInsRoleInpolicyByInsInsuranceSlip(insInsuranceSlip.getIns_insurance_slip_id());
				for(InsRoleInpolicy role : roleList){
					updateRole(vo, role);
				}
			}else{
				insRoleInpolicy = packagingInsRoleInpolicy(Long.parseLong(vo.getOid()));
				updateRole(vo, insRoleInpolicy);
			}
		}else{
			List<InsRoleInpolicy> roleList = initInsRoleInpolicy(insInsuranceSlip, vo.getRole_type(), vo.getKind());
			for(InsRoleInpolicy role : roleList){
				updateRole(vo, role);
			}
		}
	}

	private void updateRole(RoleSubjectVo vo, InsRoleInpolicy insRoleInpolicy) {
		insRoleInpolicy.setName_cn(vo.getName_cn());
		insRoleInpolicy.setName_en(vo.getName_en());
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insRoleInpolicy);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insRoleInpolicy.setApp_business_path(StringUtils.isNotEmpty(vo.getApp_business_path()) ? vo.getApp_business_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_address_path(StringUtils.isNotEmpty(vo.getApp_address_path()) ? vo.getApp_address_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_idcard_path(StringUtils.isNotEmpty(vo.getApp_idcard_path()) ? vo.getApp_idcard_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_organizing_path(StringUtils.isNotEmpty(vo.getApp_organizing_path()) ? vo.getApp_organizing_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_spouse_card_path(StringUtils.isNotEmpty(vo.getApp_spouse_card_path()) ? vo.getApp_spouse_card_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_tax_path(StringUtils.isNotEmpty(vo.getApp_tax_path()) ? vo.getApp_tax_path() : ConstProp.DIGIT_ZERO);
		insRoleInpolicy.setApp_trauschein_path(StringUtils.isNotEmpty(vo.getApp_trauschein_path()) ? vo.getApp_trauschein_path() : ConstProp.DIGIT_ZERO);
	}
	
	/**
	 * <b>根据投保单id查询投保人/被保人信息列表插入到RoleSubjectVo集合 </b> 
	 * 
	 * @param policyID 投保单id
	 * @author ZXF 
	 * @date 2017年1月8日 上午11:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	public List<RoleSubjectVo> getRoleSubjectVoListByPolicyID(Long policyID){
		List<RoleSubjectVo> voList = dao.selectRoleSubjectVoByInsInsuranceSlip(policyID);
		/*List<InsRoleInpolicy> roleList = selectInsRoleInpolicyByInsInsuranceSlip(policyID);
		if(roleList != null && roleList.size()>ConstProp.INT_NUMBER_ZERO){
			for(InsRoleInpolicy role : roleList){
				voList.add(accordingToInsRoleInpolicyIntoRoleSubjectVo(role));
			}
		}*/
		return voList;
	}
	
	/**
	 * <b>根据投保人/被保人信息转换成 RoleSubjectVo</b> 
	 * 
	 * @param role 投保人/被保人
	 * @return
	 * @author ZXF 
	 * @date 2017年1月8日 下午2:22:26
	 * @注意事项 </b>
	 * <b>
	 */
	public RoleSubjectVo accordingToInsRoleInpolicyIntoRoleSubjectVo(InsRoleInpolicy role){
		RoleSubjectVo vo = new RoleSubjectVo();
		vo.setName_cn(role.getName_cn());
		vo.setName_en(role.getName_en());
		vo.setOid(String.valueOf(role.getIns_role_inpolicy_id()));
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(role), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
		vo.setApp_address_path(ConstProp.DIGIT_ZERO.equals(role.getApp_address_path()) ? ConstProp.BLANK_CHAR : role.getApp_address_path());
		vo.setApp_business_path(ConstProp.DIGIT_ZERO.equals(role.getApp_business_path()) ? ConstProp.BLANK_CHAR : role.getApp_business_path());
		vo.setApp_idcard_path(ConstProp.DIGIT_ZERO.equals(role.getApp_idcard_path()) ? ConstProp.BLANK_CHAR : role.getApp_idcard_path());
		vo.setApp_organizing_path(ConstProp.DIGIT_ZERO.equals(role.getApp_organizing_path()) ? ConstProp.BLANK_CHAR : role.getApp_organizing_path());
		vo.setApp_spouse_card_path(ConstProp.DIGIT_ZERO.equals(role.getApp_spouse_card_path()) ? ConstProp.BLANK_CHAR : role.getApp_spouse_card_path());
		vo.setApp_tax_path(ConstProp.DIGIT_ZERO.equals(role.getApp_tax_path()) ? ConstProp.BLANK_CHAR : role.getApp_tax_path());
		vo.setApp_trauschein_path(ConstProp.DIGIT_ZERO.equals(role.getApp_trauschein_path()) ? ConstProp.BLANK_CHAR : role.getApp_trauschein_path());
		return vo;
	}

	/**
	 * <b>根据投保单id查询相关信息 </b>
	 *
	 * @param oid 投保单id
	 * @param kind 投保人/或被保人标识
	 * @return
	 * @author ZXF
	 * @date 2017年1月6日 下午4:50:59
	 * @注意事项 </b>
	 * <b>
	 */
	public List<InsRoleInpolicy> getInsRoleInpolicyListByIDAndKind(Long oid, String kind){
		Map<String,Object> columnMap = Maps.newHashMap();
		columnMap.put("insurance_slip_id", oid);
		columnMap.put("kind", kind);
		List<InsRoleInpolicy> roleList = dao.selectByMap(columnMap);
		return roleList;
	}
}
