package com.bcxin.ins.models.claim.web;

import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.util.CTLUtil;
import com.bcxin.ins.models.claim.service.InsCommonReportService;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.beans.IntrospectionException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;


/**
 * <b> 理赔业务控制器 </b>
 * @author ZXF
 * @create 2019/12/13 0013 16:05
 * @version
 * @注意事项 </b>
 */
@Controller
@RequestMapping(value = "${apiPath}/myClaim")
public class MyReportActionController extends BaseController {

	@Autowired
	private InsCommonReportService insCommonReportService;

	/** PG2.1 理赔列表 */
	private static final String REPORT_LIST = getViewPath("admin/claim/api/order_report_list");

	/** PG2.1.2 理赔详情-企业 */
	private static final String REPORT_DETATIL = getViewPath("admin/claim/api/order_report_detatil");

	@RequestMapping("/reportList_table/{sup_id}")
	public @ResponseBody Object reportList_table(HttpServletRequest request, HttpServletResponse resp,
												 @PathVariable String sup_id, @RequestParam Map<Object, Object> params) throws UnsupportedEncodingException {
		Map<Object,Object> p = CTLUtil.init(request,params);
		if ("sup_admin".equals(sup_id)) sup_id = "";
		params.put("sup_id", sup_id);
		CTLUtil.out(insCommonReportService.selectInsCommonReportVoListByOrderID(p),resp);
		return null;
	}


	/**
	 * <b> 理赔列表 </b>
	 * @author ZXF
	 * @create 2019/12/13 0013 14:21
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/findReportList/{sup_id}")
	public String findReportList(ModelMap model, @PathVariable String sup_id) throws Exception {
		if(!"sup_admin".equals(sup_id)){
			throw new Exception("403-无访问权限！");
		}
		model.addAttribute("sup_id", sup_id);
		return REPORT_LIST;
	}

	/**
	 * <b> 获取理赔详情 </b>
	 * @author ZXF
	 * @create 2019/12/13 0013 14:22
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/reportDetailByID/{oid}")
	public String reportDetailByID(@PathVariable Long oid, ModelMap model) throws InvocationTargetException, IntrospectionException, IllegalAccessException, NoSuchFieldException {
		InsCommonReportVo report = insCommonReportService.getInsCommonReportVoInfoById(oid);
		model.addAttribute("report",report);
		return REPORT_DETATIL;
	}

	/**
	 * <b> 理赔结案 </b>
	 * @author ZXF
	 * @create 2020/04/02 0002 17:02
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/settleALawsuitByID/{oid}")
	@ResponseBody
	public AjaxResult settleALawsuitByID(@PathVariable Long oid) {
		insCommonReportService.settleALawsuitByID(oid);
		return success(true);
	}
}
