<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8" %>
<%@ include file="/WEB-INF/include/taglib.jsp" %>
<!DOCTYPE HTML>
<html>
<head>
    <title>保全申请</title>
    <%@include file="/WEB-INF/include/head.jsp" %>
</head>
<style>
    @keyframes move {
        0% {
            color: #FFE6E6;
        }
        10% {
            color: #2785d0;
        }
        20% {
            color: #FFE6E6;
        }
        30% {
            color: #2785d0;
        }
        40% {
            color: #FFE6E6;
        }
        50% {
            color: #2785d0;
        }
        60% {
            color: #FFE6E6;
        }
        70% {
            color: #2785d0;
        }
        80% {
            color: #FFE6E6;
        }
        90% {
            color: #2785d0;
        }
        100% {
            color: #FFE6E6;
        }
    }
</style>
<body>
<div class="wrapper wrapper-content animated fadeInRight">

    <div class="row">
        <div class="col-sm-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h5>保全申请</h5>
                    <%--<div class="ibox-tools">--%>
                    <%--<a class="collapse-link"><i class="fa fa-chevron-up"></i></a>--%>
                    <%--<a class="close-link"><i class="fa fa-times"></i></a>--%>
                    <%--</div>--%>
                </div>

                <div class="ibox-content">
                    <div class="row row-lg">
                        <div class="col-sm-12">
                            <div class="example-wrap">
                                <div class="example">
                                    <form id="queryForm">
                                        <table>
                                            <tr>
                                                <td style="padding-left:0px;">
                                                    <div style="display:inline;padding-left:9px;">
                                                        关键字:
                                                        <input class="easyui-textbox" name="keyword" id="keyword"
                                                               data-options="prompt:'保单号/暂批改单号/批单号/投保人/姓名'" placeholder=""
                                                               style="width:275px;"/>
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        状态:
                                                        <select class="easyui-combobox"
                                                                data-options="panelWidth:100,panelHeight:128,editable:false"
                                                                name="revise_status" style="width:80px;">
                                                            <option value="">全部</option>
                                                            <option value="1">待提交</option>
                                                            <option value="2">待审核</option>
                                                            <option value="3">审核退回</option>
                                                            <option value="4">已审核</option>
                                                            <option value="5">已生效</option>
                                                        </select>
                                                    </div>
                                                    <input type="hidden" id="donotShow" name="donotShow">
                                                    <div style="display:inline;padding-left:18px;">
                                                        类型:
                                                        <select class="easyui-combobox"
                                                                data-options="panelWidth:80,panelHeight:118,editable:false"
                                                                name="revise_type" style="width:80px;">
                                                            <option value="">全部</option>
                                                            <option value="1">增员</option>
                                                            <option value="2">减员</option>
                                                            <option value="3">替换</option>
                                                        </select>
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        结算状态:
                                                        <select class="easyui-combobox"
                                                                data-options="panelWidth:80,panelHeight:118,editable:false"
                                                                name="pay_status" style="width:80px;">
                                                            <option value="">全部</option>
                                                            <option value="0">未结算</option>
                                                            <option value="1">已结算</option>
                                                        </select>
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        申请时间: 从 <input class="easyui-datebox"
                                                                       data-options="editable:false" name="start_time" id="start_time"
                                                                       style="width:125px;">
                                                        至 <input class="easyui-datebox" data-options="editable:false"
                                                                 name="end_time" id="end_time" style="width:125px;">
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="queryBtn" type="button"
                                                                class="btn  btn-primary btn-sm">
                                                            <i class="glyphicon glyphicon-search"></i> 搜索
                                                        </button>
                                                    </div>
                                                    <div style="display:inline;padding-left:18px;">
                                                        <button id="clearQueryForm" type="button"
                                                                class="btn btn-primary btn-sm ">
                                                            <i class="glyphicon glyphicon-minus"></i> 清空
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                        </table>
                                    </form>
                                    <div id="toolbar" class="btn-group m-t-sm" style="margin-left: 15px;">
                                        <c:if test="${sup_id eq 'sup_admin'}">
                                            <button id="d1Btn" type="button" class="btn btn-primary btn-sm" title="导出中华雇主当前周待审核增员、减员保全人员列表"
                                                    onclick="downRecordResultSet();">
                                                <i class="glyphicon glyphicon-download-alt"></i><span id="d1BtnText"> 导出审核人员</span>
                                            </button>
                                            <button id="d2Btn" type="button" class="btn btn-primary btn-sm" title="导出待审核、审核通过保全单人员明细"
                                                    onclick="downRecordDetail();" style="margin-left: 10px;">
                                                <i class="glyphicon glyphicon-download-alt"></i><span id="d2BtnText"> 保全单明细导出</span>
                                            </button>
                                            <button id="d3Btn" type="button" class="btn btn-primary btn-sm" title="导出审核通过保全单人员明细"
                                                    onclick="downSuccessResultSet();" style="margin-left: 10px;">
                                                <i class="glyphicon glyphicon-download-alt"></i><span id="d3BtnText"> 批单通过人员清单导出</span>
                                            </button>
                                            <button id="d5Btn" type="button" class="btn btn-warning btn-sm" title="已结算批单标记"
                                                    onclick="toLeadPP();" style="margin-left: 10px;">
                                                <i class="glyphicon glyphicon-edit"></i><span id="d5BtnText"> 已结算批单标记</span>
                                            </button>
                                        </c:if>
                                    </div>
                                    <table id="defaultTable"
                                           data-toggle="table"
                                    <%--data-show-refresh="true"--%>
                                           data-search="false"
                                           data-show-toggle="true"
                                           data-show-export="true"
                                           data-show-columns="true"
                                           data-striped="true"
                                           data-pagination="true"
                                           data-sort-name="start_time"
                                           data-url="${ctxapi}/myApply/applyList_table/${sup_id}"
                                           data-method="post"
                                           data-content-type="application/x-www-form-urlencoded; charset=UTF-8"
                                           data-side-pagination="server"
                                           data-page-list="[10, 25, 50, 100, ALL]"
                                           data-query-params="myQueryParams"
                                           data-sort-order="desc"
                                           load-success.bs.table="onLoadSuccessFn"
                                           data-toolbar="#toolbar">

                                        <thead>
                                        <div class="bs-bars pull-left" style="padding-top:27px;">
                                            <input type="checkbox"  id="checkNotShow" name="qx" value=""  />
                                            <label style="top: -2px;position: relative;" for="checkNotShow">不显示待提交批改单</label>
                                        </div>
                                        <tr>

                                            <th data-halign="center" data-align="center" data-sortable="true"
                                                data-field="revise_serial_number">暂批改单号
                                            </th>
                                            <th data-halign="center" data-align="center" data-sortable="true"
                                                data-field="revise_serial_num_ins">批单号
                                            </th>
                                            <th data-halign="center" data-align="center" data-sortable="true"
                                                data-field="external_reference">保单号
                                            </th>
                                            <th data-halign="center" data-align="center" data-sortable="true"
                                                data-field="comName">保险公司
                                            </th>
                                            <th data-halign="center" data-align="center" data-sortable="true"
                                                data-field="app_role_name">投保人
                                            </th>
                                            <th data-halign="center" data-align="center" data-sortable="true"
                                                data-field="revise_type" data-formatter="formatTypeFn">批改类型
                                            </th>
                                            <th data-halign="center" data-align="center" data-sortable="true"
                                                data-field="inception_date">生效日期
                                            </th>
                                            <th data-halign="center" data-align="center" data-sortable="true"
                                                data-field="total_premium">保全金额
                                            </th>
                                            <th data-halign="center" data-align="center" data-sortable="true"
                                                data-field="revise_status" data-formatter="formatStatsFn">状态
                                            </th>
                                            <th data-halign="center" data-align="center" data-sortable="true"
                                                data-field="pay_status" data-formatter="formatPayStatsFn">结算状态
                                            </th>
                                            <th data-halign="center" data-align="center" data-sortable="true"
                                                data-field="start_time">申请时间
                                            </th>
                                            <th data-halign="center" data-align="center" data-sortable="true"
                                                data-field="bpName">业务人员
                                            </th>
                                            <th data-halign="center" data-align="center"
                                                data-formatter="formatOperationFn">操作
                                            </th>
                                        </tr>
                                        </thead>
                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<bcxinFooter>
    <script src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />" type="text/javascript"></script>
    <script type="text/javascript">
        var _c = 1;
        $(document).ready(function () {
            //这个设置日期只是给操作人员看的，实际上是通过 function myQueryParams(params) 方法中的日期初始设置生效的
            $("#start_time").datebox("setValue", laydate.now(-90));
            $("#end_time").datebox("setValue", laydate.now(+1));
            //查询按钮
            $("#queryBtn").unbind('click').click(function () {
                $('#defaultTable').bootstrapTable('refreshOptions',{pageNumber : 1});
            });

            //清空查询列表
            $("#clearQueryForm").unbind('click').click(function () {
                $("#queryForm").form("clear");
                $('#defaultTable').bootstrapTable('refresh');
            });

        });
        //关闭窗口
        function closeLayerOpen() {
            layer.closeAll();
        }
        function refresh() {
            $('#defaultTable').bootstrapTable('refresh');
        }
        $("#checkNotShow").change(function() {
            if($('#checkNotShow').is(':checked')) {
                $('#donotShow').val('yes');
                $('#defaultTable').bootstrapTable('refresh');

            }else {

                $('#donotShow').val('no');
                $('#defaultTable').bootstrapTable('refresh');


            }

        });
        function formatStatsFn(value, row) {
            if (row.revise_status == 0) return "<span style='color:gray'>已废弃<span>";
            if (row.revise_status == 1) return "<span style='color:darkgray'>待提交<span>";
            if (row.revise_status == 2) return "<span style='color:blue'>待审核<span>";
            if (row.revise_status == 3) return "<span style='color:red'>审核退回<span>";
            if (row.revise_status == 4) return "<span style='color:green'>已审核<span>";
            if (row.revise_status == 5) return "<span style='color:green'>已生效<span>";
            return "";
        }
        function formatPayStatsFn(value, row) {
            if (row.pay_status == 0) return "<span style='color:gray'>未结算<span>";
            if (row.pay_status == 1) return "<span style='color:gray'>已结算<span>";
            return "-";
        }

        function formatTypeFn(value, row) {

            if (row.revise_type == 1) return "增员";
            if (row.revise_type == 2) return "减员";
            if (row.revise_type == 3) return "替换";

            return "";
        }

        function formatOperationFn(value, row) {
            var str = "";
            var icon = 'glyphicon glyphicon-share';
            if (row.revise_status == 2) {
                icon = 'glyphicon glyphicon-edit';
            }
            //平安的审批中按钮闪烁
            var ssvar = '';
            if(row.revise_status == 2&&row.isGP==1){
                ssvar = 'style="animation: move 15s ease-in infinite;"';
            }
            if (row.revise_type == 3) {
                var onClick2 = "member_change('" + row.ins_preservation_record_id + "');";
                str += '<a class="like m-l-sm text-info" href="javascript:void(0)" onclick="' + onClick2 + '" title="保全详情—替换人员" > <i '+ssvar+' class="glyphicon '+icon+'"></i></a>';
            } else {
                var onClick2 = "member_add('" + row.ins_preservation_record_id + "');";
                str += '<a class="like m-l-sm text-info" href="javascript:void(0)" onclick="' + onClick2 + '" title="保全详情—增减人员" > <i '+ssvar+' class="glyphicon '+icon+'"></i></a>';
            }
            if ((row.revise_status == 4||row.revise_status == 5)&&row.isGP==1&&(row.revise_path==undefined||row.revise_path=='')){
                var onClick3 = "member_downDZPD('" + row.ins_preservation_record_id + "');";
                str += '<a class="like m-l-sm text-info" href="javascript:void(0)" onclick="' + onClick3 + '" title="补电子批单" > <i class="glyphicon glyphicon-download"></i></a>';
            }

            return str;
        }

        /*保全详情—替换人员*/
        function member_change(id) {
            member_show('保全详情', '${ctxapi}/myApply/perserverDetailChangeByID/' + id+'/${sup_id}', '', 1000, 1000, null);

        }

        /*用户-启用*/
        function member_add(id) {
            member_show('保全详情', '${ctxapi}/myApply/perserverDetailAddByID/' + id+'/${sup_id}', '', 1000, 1000, null);
        }

        /*补电子批单*/
        function member_downDZPD(id) {
            g_ajax('${ctxapi}/myApply/getDZPD/'+id,{}, function(result){
                layer.msg(result.msg);
            });
        }

        function comm_back(json) {
            if (json.success == true) {
                $('#defaultTable').bootstrapTable('refresh');
                layer.msg(json.msg, {icon: 1, time: 1000});
            } else {
                layer.alert(json.msg, {icon: 2});
            }
        }

        /*人员导出操作*/
        function downRecordResultSet(){
            g_timer(8,"d1Btn","d1BtnText"," 导出审核人员");
            var str = "<div>" +
                "<p style='padding-bottom: 5px;'>关键字：<input type='text' class='form-control' placeholder='投保人/保单号' id='skeyword' /></p>" +
                "<p style='padding-bottom: 5px;'>姓名：<input type='text' class='form-control' id='sname' /></p>" +
                "<p style='padding-bottom: 5px;'>申请时间起：<input type='text' class='form-control' id='sstart_time' onClick=\"laydate({elem: '#sstart_time'})\"/></p>" +
                "<p style='padding-bottom: 5px;'>申请时间止：<input type='text' class='form-control' id='send_time' onClick=\"laydate({elem: '#send_time'})\"/></p>" +
                "</div>";
            var index = layer.confirm(str,{btn: ['下载','取消'], title: "导出（审批中）"}, function(){
                var keyword = $('#skeyword').val();
                if(keyword == undefined){
                    keyword = '';
                }
                var name = $('#sname').val();
                if(name == undefined){
                    name = '';
                }
                var start_time = $('#sstart_time').val();
                var end_time = $('#send_time').val();
                if(start_time == '' || end_time == ''){
                    layer.msg("申请时间区间未选择！", {icon: 2, time: 2000});
                    return;
                }
                location.href='${ctxapi}/myApply/down_record_result_set?keyword='+keyword+'&name='+name+'&start_time='+start_time+'&end_time='+end_time;
                layer.close(layer.index);
            });
        }

        /*保全单明细导出操作*/
        function downRecordDetail(){
            g_timer(8,"d2Btn","d2BtnText"," 保全单明细导出");
            var str = "<div>" +
                "<p style='padding-bottom: 5px;'>投保人：<input type='text' class='form-control' id='skeyword' /></p>" +
                "<p style='padding-bottom: 5px;'>姓名：<input type='text' class='form-control' id='sname' /></p>" +
                "<p style='padding-bottom: 5px;'>申请时间起：<input type='text' class='form-control' id='sstart_time' onClick=\"laydate({elem: '#sstart_time'})\"/></p>" +
                "<p style='padding-bottom: 5px;'>申请时间止：<input type='text' class='form-control' id='send_time' onClick=\"laydate({elem: '#send_time'})\"/></p>" +
                "</div>";
            var index = layer.confirm(str,{btn: ['下载','取消'], title: "导出（审批中、审批通过）"}, function(){
                var keyword = $('#skeyword').val();
                if(keyword == undefined){
                    keyword = '';
                }
                var name = $('#sname').val();
                if(name == undefined){
                    name = '';
                }
                var start_time = $('#sstart_time').val();
                var end_time = $('#send_time').val();
                if(start_time == '' || end_time == ''){
                    layer.msg("申请时间区间未选择！", {icon: 2, time: 2000});
                    return;
                }
                location.href='${ctxapi}/myApply/down_record_detail?keyword='+keyword+'&name='+name+'&start_time='+start_time+'&end_time='+end_time;
                layer.close(layer.index);
            });
        }

        function downSuccessResultSet(){
            g_timer(8,"d3Btn","d3BtnText"," 批单通过人员清单");
            var str = "<div>" +
                "<p style='padding-bottom: 5px;'>投保人：<input type='text' class='form-control' id='skeyword' /></p>" +
                "<p style='padding-bottom: 5px;'>姓名：<input type='text' class='form-control' id='sname' /></p>" +
                "<p style='padding-bottom: 5px;'>申请时间起：<input type='text' class='form-control' id='sstart_time' onClick=\"laydate({elem: '#sstart_time'})\"/></p>" +
                "<p style='padding-bottom: 5px;'>申请时间止：<input type='text' class='form-control' id='send_time' onClick=\"laydate({elem: '#send_time'})\"/></p>" +
                "<p style='padding-bottom: 5px;'>保险公司：<select type='text' class='form-control' id='stype'><option value='GZZRX-ZH' checked>中华雇主险</option><option value='GZZRX-CA'>长安雇主险</option><option value='GZZRX-PAC'>平安雇主险</option><option value='TYX-PAC' checked>平安团意险</option><option value='TYX-CA'>长安团意险</option><option value='GZZRX-QH'>前海雇主险</option><option value='GZZRX-TB'>太保雇主险</option></select></p>" +
                "<p style='padding-bottom: 5px;'>是否过期：<select type='text' class='form-control' id='isGQ'><option value='0' checked>否</option><option value='1'>是</option></select></p>" +
                "</div>";
            var index = layer.confirm(str,{btn: ['下载','取消'], title: "导出（审批通过）"}, function(){
                var keyword = $('#skeyword').val();
                if(keyword == undefined){
                    keyword = '';
                }
                var name = $('#sname').val();
                if(name == undefined){
                    name = '';
                }
                var type = $('#stype').val();
                var isGQ = $('#isGQ').val();
                var start_time = $('#sstart_time').val();
                var end_time = $('#send_time').val();
                if(isGQ=='0'&&(start_time == '' || end_time == '')){
                    layer.msg("申请时间区间未选择！", {icon: 2, time: 2000});
                    return;
                }
                location.href='${ctxapi}/myApply/down_success_result_set?keyword='+keyword+'&name='+name+'&start_time='+start_time+'&end_time='+end_time+'&type='+type+'&isGQ='+isGQ;
                layer.close(layer.index);
            });
        }

        function toLeadPP(){
            g_timer(8,"d5Btn","d5BtnText"," 已结算批单标记");
            var str = "<div style='width: 300px;'>" +
                "<p style='padding-bottom: 5px;'><textarea class=\"form-control\" rows=6 id=\"pdNo\" placeholder=\"请输入已结算批单号（多个“,”隔开）\" style=\"width: 100%\"></textarea></p>" +
                "</div>";
            var index = layer.confirm(str,{btn: ['提交','取消'], title: "录入已结算批单号（多个“,”隔开）"}, function(){
                var pdNo = $('#pdNo').val();
                if(pdNo == undefined){
                    layer.msg("请输入批单号！", {icon: 2, time: 2000});
                    return;
                }
                pdNo = pdNo.replace('，',',').replace(' ','');
                $.ajax({
                    type:'POST',
                    dataType:'json',
                    url:'${ctxapi}'+'/myApply/setPdNo',
                    data:{'pdNo':pdNo},
                    success:function(result){
                        if(result.success==true){
                            layer.msg(result.msg,{icon:1,time:1000});
                            layer.close(index);
                        }else{
                            layer.alert(result.msg, {icon: 2});
                        }
                    }
                })
            });
        }

        function myQueryParams(params) { //limit offset order sort
            console.log("参数是：" + params)
            var obj = g_sobj($("#queryForm").form());
            //只初始的时候生效一次
            if(_c==1){
                obj.start_time = laydate.now(-90);
                obj.end_time = laydate.now(+1);
                _c=0;
            }
            for (var i in obj) {
                if (obj[i] == "") eval("delete obj." + i);
            }
            return $.extend(obj, params);
        }
    </script>
</bcxinFooter>
</body>
</html>
