package com.bcxin.ins.models.web;

import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysLog;
import com.bcxin.ins.core.service.SysLogService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * 日志Controller
 * @author ThinkGem
 * @version 2013-6-2
 */
@Controller
@RequestMapping(value = "${systemPath}/sys/log")
public class SysLogController extends BaseController {

	@Autowired
	private SysLogService logService;
	
	@RequiresPermissions("sys:log:view")
	@RequestMapping(value = {"list", ""})
	public String list(SysLog log, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<SysLog> page = logService.findPage(new Page<SysLog>(), log);
        model.addAttribute("page", page);
		return "modules/sys/logList";
	}
}
