package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.core.base.service.impl.BaseServiceImpl;
import com.bcxin.ins.entity.policy_special.StTurnover;
import com.bcxin.ins.models.order.policy.dao.InsTurnoverDao;
import com.bcxin.ins.models.order.policy.service.InsForecastedDetailService;
import com.bcxin.ins.models.order.policy.service.InsRecentYearsSellService;
import com.bcxin.ins.models.order.policy.service.InsTurnoverService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.CommonExportVo_1;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


@Service
@Transactional
public class InsTurnoverServiceImpl extends ServiceImpl<InsTurnoverDao, StTurnover> implements InsTurnoverService {

	@Autowired
	private InsTurnoverDao dao;
	
	@Autowired
	private InsRecentYearsSellService insRecentYearsSellService;
	
	@Autowired
	private InsForecastedDetailService insForecastedDetailService;
	
	/**
	 * <b>根据id查询 InsTurnover 及关联表封装</b> 
	 * 
	 * @param oid
	 * @return
	 * @author ZXF 
	 * @date 2017年1月6日 上午10:46:29
	 * @注意事项 </b>
	 * <b>
	 */
	public StTurnover packagingInsTurnover(Long oid){
		StTurnover insTurnover = dao.getInsTurnover(oid);
		if(insTurnover != null){
			insTurnover.setRecentYearsSellList(insRecentYearsSellService.selectInsRecentYearsSellByTurnover(insTurnover.getSt_turnover_id()));
			insTurnover.setForecastedDetailList(insForecastedDetailService.selectInsForecastedDetailByTurnover(insTurnover.getSt_turnover_id()));
		}
		return insTurnover;
	}

	@Override
	public StTurnover initInsTurnover() {
		StTurnover insTurnover = new StTurnover();
		dao.insert(insTurnover);
		return insTurnover;
	}
	
	/**
	 * <b>根据Vo及销售额表ID更新InsTurnover数据 </b> 
	 * 
	 * @param vo
	 * @param insTurnoverID 销售额表id
	 * @author ZXF 
	 * @date 2017年1月7日 下午4:26:25
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToTheCommonExportVo_1SetUpInsTurnover(CommonExportVo_1 vo, Long insTurnoverID){
		StTurnover insTurnover = dao.selectById(insTurnoverID);
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(vo), insTurnover);
		} catch (Exception e) {
			e.printStackTrace();
		}
		dao.updateById(insTurnover);
	}
	
	/**
	 * <b>根据销售额表信息转换成 CommonExportVo_1 </b> 
	 * 
	 * @param insTurnover
	 * @param vo
	 * @return
	 * @author ZXF 
	 * @date 2017年1月8日 下午3:10:03
	 * @注意事项 </b>
	 * <b>
	 */
	public void accordingToInsTurnoverIntoCommonExportVo_1(CommonExportVo_1 vo, StTurnover insTurnover){
		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insTurnover), vo);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
}
