package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.entity.policy_core.InsAgreement;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.models.order.policy.dao.InsAgreementDao;
import com.bcxin.ins.models.order.policy.service.InsAgreementService;
import com.bcxin.ins.models.order.policy.service.InsInsuranceSlipService;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.vo.InsurePolicyVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;



/**
 * <b>保单主表业务处理 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:28:33
 * @注意事项 </b>
 * <b>
 */
@Service
@Transactional
public class InsAgreementServiceImpl extends ServiceImpl<InsAgreementDao, InsAgreement> implements InsAgreementService {

	@Autowired
	private InsAgreementDao dao;

	public InsAgreement initAgreement(){
		InsAgreement insAgreement = new InsAgreement();
		dao.insert(insAgreement);
		return insAgreement;
	}

	@Autowired
	private InsInsuranceSlipService insInsuranceSlipService;

	/**
	 * <b>查询保单信息根据保单id </b>
	 *原：getInsAgreementgExtendsParent
	 * @param oid 保单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月5日 下午3:54:36
	 * @注意事项 </b>
	 * <b>
	 */
	public InsAgreement selectById(Long oid){
		return dao.selectById(oid);
	}

	/**
	 * <b>通过投保定单id查询保单信息 </b>
	 *原：selectInsAgreementgByInsInsuranceSlipg
	 * @param insurance_slip_id 投保单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月5日 下午3:54:36
	 * @注意事项 </b>
	 * <b>
	 */
	public InsAgreement selectInsAgreementByInsInsuranceSlip(Long insurance_slip_id){
		return dao.selectInsAgreementByInsInsuranceSlip(insurance_slip_id);
	}

	/**
	 * <b>将InsurePolicyVo转换成保单信息 </b>
	 *原：willInsurePolicyVoChangeIntoInsAgreementg
	 * @param insurance_slip_id 投保定单id
	 * @return
	 * @author ZXF
	 * @date 2017年1月5日 下午3:54:36
	 * @注意事项 </b>
	 * <b>
	 */
	public void willInsurePolicyVoChangeIntoInsAgreement(Long insurance_slip_id,String externalReference){
		InsAgreement insAgreement = selectInsAgreementByInsInsuranceSlip(insurance_slip_id);
		if(insAgreement == null){
			insAgreement = initAgreement();
		}
		InsInsuranceSlip insInsuranceSlip = insInsuranceSlipService.packagingInsInsuranceSlip(insurance_slip_id);
//		InsurePolicyVo vo = insInsuranceSlipService.willInsInsuranceSlipChangeIntoInsurePolicyVo(insurance_slip_id);

		try {
			MyConverUtil.map2PO(MyConverUtil.PO2Map(insInsuranceSlip), insAgreement);
		} catch (Exception e) {
			e.printStackTrace();
		}
		insAgreement.setExternal_reference(externalReference);
		insAgreement.setPro_primary(insInsuranceSlip.getPro_primary());
		insAgreement.setIns_insurance_slip(insInsuranceSlip);
		insAgreement.setMail_policy_id(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
		insAgreement.setRegister_user_id(insInsuranceSlip.getRegister_user_id());
		insAgreement.setSpecial_id(insInsuranceSlip.getSpecial_id());
		dao.updateById(insAgreement);
	}
}
