package com.bcxin.ins.models.order.policy.service;

import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.vo.*;
import org.springframework.web.bind.annotation.ModelAttribute;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

public interface InsuranceOperationService {

    public UnderwriteVo getUnderwriteByOrder(InsInsuranceSlip order);

    public void creatLog(HttpServletRequest request, String title, Exception ex, String com_id);

    public AjaxResult updateOrderAudit(String signOperate, UnderwriteVo vo, Long order_id);

    public AjaxResult updateOrderAudit_API(HttpServletRequest request, String signOperate, String sup_id, UnderwriteVo vo, Long order_id);

    public String orderAuditFail(String ty, String remarks, Long order_id);

    public String orderAuditFail_API(HttpServletRequest request, String sup_id, String ty, String remarks, Long order_id);

    public AjaxResult updateOrderUnderwriting(OrderFormVo orderFormVo, String underwritingOid, String acceptanceTime, String out_of_pocket, String signOperate);

    public AjaxResult updateOrderUnderwriting_API(HttpServletRequest request, String sup_id, OrderFormVo orderFormVo, String underwritingOid, String acceptanceTime, String out_of_pocket, String signOperate);

    public AjaxResult updateTransactionPayOrderNumber(String[] payOrderNumbers, String order_id);

    public AjaxResult updateInsRolePolicyLink(ParamVo paramVo);

    public AjaxResult updateTransactionPayOrderNumber_API(HttpServletRequest request, String sup_id, String[] payOrderNumbers, String order_id);


    public InsInsuranceSlip initOrderCorrelation(Long poductID, Long user_id);

    public void setMicroExportByMicroExportVo(MicroExportVo vo);

    public MicroExportVo getMicroExportVoByOrderID(Long orderID);

    public void setCommonExportByCommonExportVo_1(CommonExportVo_1 vo);

    public void setCommonExportByCommonExportVo_2(CommonExportVo_2 vo);

    public void setCommonExportByCommonExportVo_3(CommonExportVo_3 vo);

    public CommonExportVo_1 getCommonExportVo_1ByOrderID(Long orderID);

    public CommonExportVo_2 getCommonExportVo_2ByOrderID(Long orderID);

    public CommonExportVo_3 getCommonExportVo_3ByOrderID(Long orderID);

    public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(Long user_id, String status, DwzPage page);

    public OrderStatusCountVo selectOrderStatusCountVoByUserID(Long user_id);

    public List<ProductVo> selectProductVoList(ProPrimary insProduct);

    public ProductVo accordingToInsProductIDToGetInsProductInProductVo(Long insProductID);

    public OrderFormVo accordingToOrderIDToGetOrderFormVo(Long order_id);

    public AdviceNoteVo accordingToOrderIDToGetAdviceNoteVo(Long order_id);

    public String updateOrderFormStatus(OrderFormVo vo);

    public AjaxResult orderUnSyncDispose();

    public AjaxResult orderUnSyncDispose_API(HttpServletRequest request);

    public void orderSyncZC(String oid);

    public String uploadPayMentFileToTranction(String path_url, String order_id, String path_sign);

    public String accordingToOrderIDGainPathSign(String order_id);

    public void accordingToInsTopBuyersListGainInsRiskDuty(Long order_id);

    public void accordingToOrderIDCreatePolicySerialNumber(Long order_id);

    public List<InsTransaction> accordingToOrderIDToGetInsTransaction(Long order_id);


    /****************************BUILD*******************************/


    public SpecialBidVo getSpecialBidVoByOrderID(Long orderID);

    public SpecialPerformanceVo_1 getSpecialPerformanceVo_1ByOrderID(Long orderID);

    public SpecialPerformanceVo_2 getSpecialPerformanceVo_2ByOrderID(Long orderID);

    public SpecialPerformanceVo_3 getSpecialPerformanceVo_3ByOrderID(Long orderID);


    /****************************LAWSUIT*******************************/


    public SpecialLitigationVo_1 getSpecialLitigationVo_1ByOrderID(Long orderID);

    public SpecialLitigationVo_2 getSpecialLitigationVo_2ByOrderID(Long orderID);

    public SpecialLitigationVo_3 getSpecialLitigationVo_3ByOrderID(Long orderID);


    /****************************GMR*******************************/


    public GMRPolicyVo getGMRPolicyVoByOrderID(Long orderID);

    /****************************GZZRX*******************************/


    public SpecialHirelingVo getSpecialHirelingVoByOrderID(Long orderID);

    /****************************AFR*******************************/


    public SpecialPublicDutyVo getSpecialPublicDutyVoByOrderID(Long orderID);


    /****************************ZZX*******************************/


    public LOTEPolicyVo getLOTEPolicyVoByOrderID(Long orderID);

    /****************************GYX*******************************/


    public GYXPolicyVo getGYXPolicyVoByOrderID(Long orderID);

    public List<Map<String,String>> findPersonByTYX(Long orderID);

    public List<Map<String,String>> findPersonByGZZRX(Long orderID);

    /**
     * <b> 订单复制，只有待支付才有此功能 </b>
     * @author ZXF
     * @create 2019/08/14 0014 11:33
     * @version
     * @注意事项 </b>
     */
    public AjaxResult copyPolicy(Long orderID);

    /**
     * <b> 保单退保 </b>
     * @author ZXF
     * @create 2020/01/10 0010 10:14
     * @version
     * @注意事项 </b>
     */
    public AjaxResult surrender(SurrenderVo surrenderVo, HttpServletRequest request);
}
