package com.bcxin.utils.wps;


import com.bcxin.config.WPSConfig;
import com.bcxin.utils.ConfigUtil;
import com.bcxin.utils.constant.ResultEnum;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

/**
 * @author jianjun.wang
 * @version V1.0
 * @className WPSUtils
 * @packageName com.bcxin.utils.wps
 * @description 封装wps常用的一些方法类
 * @data 2019-09-02 13:54
 **/
public final class WPSUtils {
    private final static String enc = "UTF-8";

    private WPSUtils() {}

    /**
     * 获取token信息
     * @param request
     * @return
     */
    public static String getToken(HttpServletRequest request) {
        return request.getHeader(WPSConfig.HEADER_TOKEN_KEY);
    }

    /**
     * 获取文件id信息
     * @param request
     * @return
     */
    public static String getFileId(HttpServletRequest request) {
        return request.getHeader(WPSConfig.HEADER_FILE_ID_KEY);
    }

    public static Map<String,Object> newSuccessMap(){
        Map<String,Object> resultMap = new HashMap<>();

        setResult(resultMap, ResultEnum.SUCCESS);

        return resultMap;
    }

    public static void setResult(Map<String,Object> resultMap,ResultEnum wpsErrorCodeEnums){
        resultMap.put(WPSConfig.RESULT_CODE_KEY, wpsErrorCodeEnums.getCode());
        resultMap.put(WPSConfig.RESULT_MSG_KEY, wpsErrorCodeEnums.getMsg());

    }

    /**
     * 给文件生成在线打开的url
     * @param fileId
     * @return
     */
    public static String generateOnlineUrl(String type, String fileId, String filePath, String readonly, String... params) throws UnsupportedEncodingException {
        StringBuffer url = new StringBuffer(WPSConfig.BASE_ONLINE_URL);

        url.append(type).append("/");
        url.append(fileId).append("?");
        url.append("_w_appid=").append(ConfigUtil.getValue("app_id"));
        url.append("&_w_filepath=").append(filePath);
        url.append("&_w_readonly=").append(readonly);

        Map<String, String> paramsMap = new HashMap<>();
        paramsMap.put("_w_appid", ConfigUtil.getValue("app_id"));
        paramsMap.put("_w_filepath", filePath);
        //增加读写参数readonly
        paramsMap.put("_w_readonly", readonly);

        if (params != null && params.length > 0) {
            for (int i = 1; i <= params.length; i++) {
                url.append("&_w_param").append(i).append("=").append(params[i - 1]);
                paramsMap.put("_w_param" + i, params[i - 1]);
            }
        }

        String sign = WpsSignatureUtils.getSignature(paramsMap, ConfigUtil.getValue("app_id"), ConfigUtil.getValue("app_key"));

        sign = URLEncoder.encode(sign, enc);

        url.append("&_w_signature=").append(sign);

        return url.toString();
    }

    public static void main(String[] args) throws Exception{
        String type = "w";
        String fileId = "1";

        String url = generateOnlineUrl(type,fileId,"22",null);

        System.out.println("url:"+url);
    }
}
