package com.bcxin.utils;

import com.bcxin.utils.constant.ResultEnum;
import com.bcxin.vo.wps.ResultVo;

/**
 * @version V1.0
 * @author jianjun.wang
 * @className ResultUtil
 * @packageName com.bcxin.utils
 * @description 统一返回工具类
 * @data 2019-09-02 13:54
 **/
public class ResultUtil {
    /**成功且带数据**/
    public static ResultVo success(Object object){
        ResultVo result = new ResultVo();
        result.setCode(ResultEnum.SUCCESS.getCode());
        result.setMsg(ResultEnum.SUCCESS.getMsg());
        result.setData(object);
        return result;
    }
    /**成功但不带数据**/
    public static ResultVo success(){

        return success(null);
    }
    /**失败**/
    public static ResultVo error(Integer code,String msg){
        ResultVo result = new ResultVo();
        result.setCode(code);
        result.setMsg(msg);
        return result;
    }
    public static ResultVo error(){
        ResultVo result = new ResultVo();
        result.setCode(ResultEnum.FAIL.getCode());
        result.setMsg(ResultEnum.FAIL.getMsg());
        return result;
    }
}
