package com.bcxin.service.impl;

import com.bcxin.service.IFilePreview;
import com.bcxin.utils.ConfigUtil;
import com.bcxin.utils.FileUtils;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.springframework.web.context.request.RequestContextHolder;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by kl on 2018/1/17.
 * Content :图片文件处理
 */
@Service
public class PictureIFilePreviewImpl implements IFilePreview {

    @Resource
    private FileUtils fileUtils;

    @Override
    public String filePreviewHandle(String url, Model model) {
        String fileKey=(String) RequestContextHolder.currentRequestAttributes().getAttribute("fileKey",0);
        List<String> imgUrls = Lists.newArrayList(url);
        try{
            imgUrls.clear();
            imgUrls.addAll(fileUtils.getRedisImgUrls(fileKey));
        }catch (Exception e){
            imgUrls = Lists.newArrayList(url);
        }
        /* 本地链接，需重新组装 */
        if (url.contains("8012")) {
            url = url.substring(0,url.indexOf("8012")+5) + "getResource?path=" + Files.getNameWithoutExtension(url)+"."+Files.getFileExtension(url);
            model.addAttribute("currentUrl",url);
            return "localPicture";
        } else {
            System.out.println("============> currentUrl:"+url);
            if(!url.contains("/getResource?path=")){
                List<String> ius = Lists.newArrayList();
                for(String u : imgUrls){
                    ius.add(u.replace(ConfigUtil.getValue("web_url"),ConfigUtil.getValue("web_url")+"/getResource?path=").replace("=/","="));
                }
                imgUrls = ius;
                url = url.replace(ConfigUtil.getValue("web_url"),ConfigUtil.getValue("web_url")+"/getResource?path=").replace("=/","=");
            }
            model.addAttribute("imgurls", imgUrls);
            model.addAttribute("currentUrl",url);
            return "picture";
        }
    }

    public static void main(String[] args) {
        List<String> imgUrls = Lists.newArrayList();
        imgUrls.add("http://localhost:8012/D:/data/openoffice/temp/1600153009977788809.zip_Scan_0001.jpg");
        imgUrls.add("http://localhost:8012/D:/data/openoffice/temp/1600153009977788809.zip_Scan_0002.jpg");
        imgUrls.add("http://localhost:8012/D:/data/openoffice/temp/1600153009977788809.zip_Scan_0003.jpg");
        imgUrls.add("http://localhost:8012/D:/data/openoffice/temp/1600153009977788809.zip_Scan_0004.jpg");
        for(String u : imgUrls){
            u.replace("http://localhost:8012/","http://localhost:8012/getResource?path=");
        }
        System.out.println(imgUrls);
//        String url = "http://localhost:8012/D:/data/openoffice/temp/1600153009977788809.zip_Scan_0004.jpg";
//        /* 本地链接，需重新组装 */
//        if (url.contains("8012")) {
//            String newUrl = url.substring(0,url.indexOf("8012")+5) + "getResource?path=" + Files.getNameWithoutExtension(url)+"."+Files.getFileExtension(url);
//            System.out.println(newUrl);
//        }
    }
}
