/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.system.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.base.dto.SAASResultDto;
import com.bcxin.auth.system.domain.DataSyncLog;
import com.bcxin.auth.system.domain.SysInterfaceLog;
import com.bcxin.auth.system.dto.datasync.DataSyncDto;
import com.bcxin.auth.system.mapper.SysInterfaceLogMapper;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthAjaxResult;
import com.github.pagehelper.util.StringUtil;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataSyncInterfaceUtil {
    private static Logger logger = LoggerFactory.getLogger(DataSyncInterfaceUtil.class);
    @Autowired
    private SysInterfaceLogMapper interfaceLogMapper;
    @Autowired
    private ConfigUtil configUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthAjaxResult callInterface(String url, DataSyncLog dataSyncLog) {
        DataSyncDto dataSyncDto = new DataSyncDto();
        dataSyncDto.setRegionId(this.configUtil.getCurrentProvince());
        dataSyncDto.setBusinessId(dataSyncLog.getId() + "");
        dataSyncDto.setData(JSON.toJSONString((Object)((Object)dataSyncLog)));
        dataSyncDto.setTargetServiceUrl("/dataSync/receive");
        dataSyncDto.setCallbackUrl(this.configUtil.getTimeUrl() + "/dataSync/callback");
        dataSyncDto.setSrcApp(this.configUtil.getTimeUrl());
        dataSyncDto.setTargetApp(this.configUtil.getTargetTimeUrl());
        dataSyncDto.setFileUrls(this.configUtil.getTimeUrl() + dataSyncLog.getUrl());
        Map paramMap = BeanUtil.beanToMap((Object)dataSyncDto);
        String msg = "";
        Boolean result = true;
        Object data = null;
        url = this.configUtil.getDataSyncFtpUrl() + url;
        SysInterfaceLog interfaceLog = new SysInterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setUrl(url);
        interfaceLog.setActive(true);
        interfaceLog.setParameters(JSONObject.toJSONString((Object)paramMap));
        try {
            logger.error("\u8bf7\u6c42\u5730\u5740:{}", (Object)url);
            logger.error("\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)paramMap));
            String resultStr = HttpUtil.post((String)url, (Map)paramMap, (int)30000);
            logger.error("\u8fd4\u56de\u7ed3\u679c:{}", (Object)resultStr);
            interfaceLog.setResult(resultStr);
            SAASResultDto resultDto = (SAASResultDto)JSONObject.parseObject((String)resultStr, SAASResultDto.class);
            if (resultDto != null && StringUtil.isNotEmpty((String)resultDto.getRetType())) {
                String retType = resultDto.getRetType();
                if ("0".equals(retType)) {
                    data = resultDto.getData();
                    logger.info("\u8c03\u7528FTP\u540c\u6b65\u670d\u52a1\u6210\u529f");
                } else {
                    result = false;
                    msg = resultDto.getMsg();
                    logger.error(resultStr);
                    logger.info("\u8c03\u7528FTP\u540c\u6b65\u670d\u52a1\u5931\u8d25");
                }
            } else {
                result = false;
                msg = "\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c";
                logger.info("\u8c03\u7528FTP\u540c\u6b65\u670d\u52a1\u5931\u8d25,\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c");
            }
        }
        catch (Exception e) {
            result = false;
            logger.error(e.getMessage(), (Throwable)e);
            msg = e.getMessage();
            interfaceLog.setResult(e.getMessage());
        }
        finally {
            interfaceLog.setUpdateTime(new Date());
            interfaceLog.setSuccessful(result);
            new Thread(() -> this.interfaceLogMapper.insert(interfaceLog)).start();
            if (StringUtil.isNotEmpty((String)msg)) {
                msg = "\u8c03\u7528FTP\u540c\u6b65\u670d\u52a1\u5931\u8d25:" + msg;
            }
        }
        return new AuthAjaxResult(result, msg, data);
    }
}

