/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.auth.system.domain.ComCerDto;
import com.bcxin.auth.system.mapper.ComCerMapper;
import com.bcxin.auth.system.service.ComCerService;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ComCerServiceImpl
implements ComCerService {
    private static Logger logger = LoggerFactory.getLogger(ComCerServiceImpl.class);
    @Autowired
    private ComCerMapper comCerMapper;

    @Override
    public int insert(ComCerDto comCerDto) {
        return this.comCerMapper.insertComCer(comCerDto);
    }

    @Override
    public void update(ComCerDto comCerDto) {
        this.comCerMapper.updateComCer(comCerDto);
    }

    @Override
    public void updatePrintState(ComCerDto comCerDto) {
        this.comCerMapper.updatePrintState(comCerDto);
    }

    @Override
    public void updateCallBackState(ComCerDto comCerDto) {
        this.comCerMapper.updateCallBackState(comCerDto);
    }

    @Override
    public void cancelPrint(ComCerDto comCerDto) {
        this.comCerMapper.cancelPrint(comCerDto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generatePrintRecord(ComCerDto comCerDto) {
        HashMap params = Maps.newHashMap();
        params.put("id", comCerDto.getBusinessid());
        params.put("printDate", comCerDto.getPrintDate());
        params.put("printOrganization", comCerDto.getPrintorganization());
        params.put("printPeople", comCerDto.getPrintpeople());
        String zf = "";
        zf = comCerDto.getZf().equals("z") ? "\u6b63\u672c" : "\u526f\u672c";
        params.put("certificateType", zf);
        String returnValue = "";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(comCerDto.getCall_back_url());
            RequestConfig.Builder requestConfig = RequestConfig.custom();
            requestConfig.setConnectTimeout(30000);
            requestConfig.setConnectionRequestTimeout(30000);
            requestConfig.setSocketTimeout(30000);
            StringEntity requestEntity = new StringEntity(JSON.toJSONString((Object)params), "utf-8");
            requestEntity.setContentEncoding("UTF-8");
            System.out.println(requestEntity);
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader("accessToken", comCerDto.getAccess_token());
            System.out.println(httpPost);
            httpPost.setConfig(requestConfig.build());
            httpPost.setEntity((HttpEntity)requestEntity);
            returnValue = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    @Override
    public List<ComCerDto> findUnUploadRecord() {
        return this.comCerMapper.findUnUploadRecord();
    }

    @Override
    public ComCerDto findById(String id) {
        return this.comCerMapper.findById(id);
    }
}

