package com.bcxin.zw.service.impl;

import com.bcxin.auth.common.constant.Constants;
import com.bcxin.obpm.dto.PerPhotoDto;
import com.bcxin.obpm.util.DateUtil;
import com.bcxin.zw.domain.Pctinfo;
import com.bcxin.zw.mapper.BazwMapper;
import com.bcxin.zw.service.ZWService;
import com.github.pagehelper.util.StringUtil;
import org.apache.axis.client.Call;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.ByteArrayInputStream;
import java.util.List;

/**
 * 南宁指纹
 */
@Service("zwService_450100")
public class NNZWServiceImpl implements ZWService {

    /**
     * 日志对象
     */
    protected Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private BazwMapper bazwMapper;

    /***
     * 根据身份证从人口库获取指纹信息(广西)
     * @param perPhotoDto
     * @return 指纹信息
     */
    public String queryZWForIdNumber(PerPhotoDto perPhotoDto) {

        String result = "";
        String xml = "";
        //拼接报文
        StringBuffer requestSoap = new StringBuffer();
        // 头部
        requestSoap.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        //添加code
        requestSoap.append("<Package>");
        requestSoap.append("<PackageHead>");
        requestSoap.append("<BBH>2.0</BBH>");//暂定为2.00
        requestSoap.append("<SJBBH>450000000000201905300001</SJBBH>");//查看已发布服务的说明
        requestSoap.append("<SJBLX>ba_zw_hc</SJBLX>");//查看已发布服务的说明
        requestSoap.append("<DWDM>" + perPhotoDto.getPhoto() + "</DWDM>");//发送单位的代码
        requestSoap.append("<DWMC>" + perPhotoDto.getName() + "</DWMC>");//发送单位的名称
        requestSoap.append("<JLS>1</JLS>");//由不超过5位数字字符组成
        requestSoap.append("<FSSJ>" + DateUtil.getCurrentDate(DateUtil.FORMAT8) + "</FSSJ>");//年月日时分秒
        requestSoap.append("</PackageHead>");

        requestSoap.append("<Data>");
        requestSoap.append("<Record>");
        requestSoap.append("<gmsfhm>" + perPhotoDto.getIdNum().toUpperCase() + "</gmsfhm>");//身份证号
        requestSoap.append("</Record>");
        requestSoap.append("</Data>");
        //添加尾部
        requestSoap.append("</Package>");
        try {
            // 直接引用远程的wsdl文件
            org.apache.axis.client.Service service = new org.apache.axis.client.Service();
            Call call = (Call) service.createCall();
            //地址
            call.setTargetEndpointAddress(Constants.GXZWAddress);
            call.setOperationName("sjpsfw");// WSDL里面描述的接口名称
            call.addParameter("dbSource",
                    org.apache.axis.encoding.XMLType.XSD_DATE,
                    javax.xml.rpc.ParameterMode.IN);// 接口的参数，dbSource：数据源，接口内部标识，现暂定为tchdb，
            String tchdb = "tchdb";
            call.addParameter("psxml",
                    org.apache.axis.encoding.XMLType.XSD_DATE,
                    javax.xml.rpc.ParameterMode.IN);// 接口的参数,psxml：交换数据内容
            call.setReturnType(org.apache.axis.encoding.XMLType.XSD_STRING);// 设置返回类型
            xml = (String) call.invoke(new Object[]{tchdb, requestSoap.toString()});
            // 给方法传递参数，并且调用方法
            SAXReader reader = new SAXReader();
            org.dom4j.Document doc = reader.read(new ByteArrayInputStream(xml.getBytes("UTF-8")));
            Element root = doc.getRootElement();
            if (root.element("Data") != null) {
                if (root.element("Data").element("Record") != null) {
                    List<Element> list = root.element("Data").element("Record").elements();
                    if (list != null && list.size() >= 3) {
                        Element ezw = list.get(2);
                        String iszw = ezw.getText();
                        if (Constants.FINGER_YES.equals(iszw)) {
                            Element e = list.get(0);
                            result = e.getText();
                        }
                    }
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            logger.error("人口库获取异常" + perPhotoDto.getIdNum());
        }
        return result;
    }

    @Override
    public Pctinfo getZWByIdnumber(String idNumber) {
        Pctinfo result = null;
        //指纹库
        List list  = bazwMapper.findByIdnumber(idNumber);
        if(list!=null && list.size()>0){
            result = (Pctinfo)list.get(0);
        }else{
            //人口库
            PerPhotoDto  perPhotoDto =  new PerPhotoDto();
            //PoliceCode("450000030000");
            perPhotoDto.setPhoto("450000030000");
            //PoliceName
            perPhotoDto.setName("广西公安厅治安警察总队");
            perPhotoDto.setIdNum(idNumber);

            String zw = queryZWForIdNumber(perPhotoDto);
            if(StringUtil.isNotEmpty(zw)) {
                result = new Pctinfo();
                result.setBarcode(zw);
                result.setIdnumber(idNumber);

            }
        }
        return result;
    }
}
