package com.bcxin.obpm.util;

import cn.hutool.core.util.HexUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.common.utils.HttpUtil;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthAjaxResult;
import com.bcxin.obpm.dto.DahuaFaceVerifyResult;
import com.bcxin.obpm.dto.FaceResult;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import javax.annotation.Resource;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/***
 * 人脸认证
 */
@Component
public class FaceUtil {
    /***
     *  日志
     */
    private static final Logger logger = LoggerFactory.getLogger(FaceUtil.class);
    /***
     * 认证地址
     */
    @Value("${match-face}")
	private String FACE_MATCH_URL;

	@Resource
	private ConfigUtil configUtil;

    /***
     * 图片转换成base64
     * @param imgPath 图片路径
     * @return
     */
	public  String ImageToBase64(String imgPath) {
		//返回的字符串
		String result = "";
		byte[] data = null;
		try {
			InputStream in = new FileInputStream(imgPath);
			data = new byte[in.available()];
			in.read(data);
			in.close();
			result = base64Encode(data);
		} catch (IOException e) {
            logger.error(e.getMessage(),e);
		}
		return result;
	}

	/***
	 * 去悼base64encode的
	 * @param base64
	 * @return
	 */
	public String base64Encode(byte[] base64){
		BASE64Encoder encoder = new BASE64Encoder();
		return encoder.encode(Objects.requireNonNull(base64)).replaceAll("[\\s*\t\n\r]", "");
	}
    /***
     * 发起人像比对的请求
     * @param img1 图片1
     * @param img2 图片2
     * @return  比对结果
     */
	public  String  facematch( String img1, String img2) throws IOException {
	    StringBuffer result = new StringBuffer();
		HttpURLConnection connection = null;
		BufferedReader in = null;
		try {
			URL url = new URL(FACE_MATCH_URL);
			connection = (HttpURLConnection) url.openConnection();
			connection.setRequestMethod("POST");	
			connection.setInstanceFollowRedirects(false);
			connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			connection.setDoOutput(true);
			connection.setDoInput(true);
			OutputStream out = new DataOutputStream(connection.getOutputStream());
			StringBuilder sb = new StringBuilder();
			sb.append("image1=");  
			sb.append(img1);
			sb.append("&image2=");
			sb.append(img2);
			out.write(sb.toString().getBytes());  
			out.flush();
			out.close();
			int status = connection.getResponseCode();
			if (status == HttpURLConnection.HTTP_OK) {
				in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
				String tmp;
				while((tmp = in.readLine()) != null) {
                    result.append(tmp);
				}
			}
		} catch(IOException e) {
            logger.error(e.getMessage(),e);
            throw e;
		} finally {
			if (null != in) {
				try {
					in.close();
				} catch (IOException e) {
                    logger.error(e.getMessage(),e);
				}
			}
			connection.disconnect();
		}
		return result.toString();
	}
    /***
     * 发起人像比对的请求(虹软)
     * @param img1 图片1
     * @param img2 图片2
     * @return  比对结果
     */
	public String facematchWithHongRuan( String img1, String img2) throws Exception {
		Map<String, Object> params = new HashMap<>();
		params.put("first", Base64.getDecoder().decode(img1));
		params.put("second", Base64.getDecoder().decode(img2));
		String result = HttpUtils.postWithJson(FACE_MATCH_URL, params);
		logger.error("返回结果：{}",result);
		if(StringUtils.isNotEmpty(result)){
			AuthAjaxResult ajaxResult = JSON.parseObject(result, AuthAjaxResult.class);

			if(ajaxResult.isSuccessful()) {
				JSONObject json = JSON.parseObject(JSON.toJSONString(ajaxResult.getData()));
				FaceResult faceResult = new FaceResult();
				faceResult.setScore(Float.parseFloat(json.getString("faceSimilarScore"))*100);
				return JSON.toJSONString(faceResult);
			}else{
				JSONObject error = JSON.parseObject(result);
				throw new Exception("虹软比对失败，" +error.getString("message"));
			}
		}else{
			throw new Exception("虹软比对失败，返回空");
		}
	}
	/***
	 * 发起人像比对的请求（大华）
	 * @param img1 图片1
	 * @param img2 图片2
	 * @return  比对结果
	 */
	public  String  facematchWithDahua(String img1, String img2) throws Exception {
		logger.error("发起人像比对的请求（大华）");
		Map<String, String> daHuaHeaderMap = getDaHuaHeaderMap();
		logger.error("请求头部：{}", JSONObject.toJSONString(daHuaHeaderMap));
		Map<String, Object> params = new HashMap<>();
		params.put("srcFaceImage", img1);
		params.put("dstFaceImage", img2);
		String param = JSONObject.toJSONString(params);
		logger.error("请求参数：{}", param);
		String result = HttpUtil.post(FACE_MATCH_URL, param, daHuaHeaderMap);
		logger.error("返回结果：{}",result);
		if(StringUtils.isNotEmpty(result)){
			DahuaFaceVerifyResult faceVerifyResult = JSONObject.parseObject(result, DahuaFaceVerifyResult.class);
			if(faceVerifyResult != null && faceVerifyResult.getSimilarity() != null) {
				FaceResult faceResult = new FaceResult();
				faceResult.setScore((float) (faceVerifyResult.getSimilarity()*100));
				return JSONObject.toJSONString(faceResult);
			} else {
				throw new Exception("大华比对失败，" + result);
			}
		} else {
			throw new Exception("大华比对失败，返回空");
		}
	}

	/**
	 * description：获取晋城市公安局服务总线接口请求头部信息
	 * author：linchunpeng
	 * date：2025/5/7
	 */
	private static Map<String, String> getDaHuaHeaderMap() {
		Map<String, String> headerMap = Maps.newHashMap();
		//访问密钥
		String ak = "QkzBz5Z5BxCFjXNs";
		headerMap.put("X-Ca-AccessKey", ak);
		//安全密钥
		String sk = "58EpDtsKwWNNinxwbwwpFXw366SkcdpX";
		//请求编号
		String nonce = cn.hutool.core.lang.UUID.randomUUID().toString().replace("-", "");
		headerMap.put("X-Ca-Nonce", nonce);
		//请求时间戳
		String timestamp = System.currentTimeMillis() + "";
		headerMap.put("X-Ca-Timestamp", timestamp);
		String signStr = ak + nonce + timestamp + sk;
		//⽣成签名
		try {
			String sign = HexUtil.encodeHexStr(MessageDigest.getInstance("MD5").digest(signStr.getBytes(StandardCharsets.UTF_8)));
			headerMap.put("X-Ca-Sign", sign);
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		}
		return headerMap;
	}

	public static void main(String[] args) {
		Map<String, String> daHuaHeaderMap = getDaHuaHeaderMap();
		System.out.println("请求头部：" + JSONObject.toJSONString(daHuaHeaderMap));
	}

	/***
	 * 返回人像比对结果，通过返回true，不通过返回false
	 * @param img1 人像一
	 * @param img2 人像二
	 * @return  比对结果
	 */
	public boolean matchResult(String img1, String img2) throws Exception {
		//logger.error("img1:"+img1);
		//logger.error("img2:"+img2);
		boolean result  = false;
		//人像比对
		String matchStr =  StringUtils.EMPTY;

		String current_native = configUtil.getCurrentNative();

		if(Constants.BEIJING.equals(current_native) || Constants.NINGXIA.equals(current_native)){
			matchStr = facematchWithHongRuan(img1,img2);
		} else if(Constants.JINCHENG.equals(current_native)){
			matchStr = facematchWithDahua(img1,img2);
		} else {
			matchStr = facematch(img1,img2);
		}

		if(StringUtils.isNotEmpty(matchStr)) {
			//json格式转换
			FaceResult faceResult = JSONObject.parseObject(matchStr, FaceResult.class);
			//大于80证明同一个人
			logger.error("faceResult.Score:"+faceResult.getScore());
			if(faceResult.getScore() >= 80){
				result = true;
			}
		}
		return result;
	}

	public static String imageToBase64ByOnline(String imgURL) {
		ByteArrayOutputStream data = new ByteArrayOutputStream();
		try {
			// 创建URL
			URL url = new URL(imgURL);
			byte[] by = new byte[1024];
			// 创建链接
			HttpURLConnection conn = (HttpURLConnection) url.openConnection();
			conn.setRequestMethod("GET");
			conn.setConnectTimeout(5000);
			InputStream is = conn.getInputStream();
			// 将内容读取内存中
			int len = -1;
			while ((len = is.read(by)) != -1) {
				data.write(by, 0, len);
			}
			// 关闭流
			is.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
		// 对字节数组Base64编码
		BASE64Encoder encoder = new BASE64Encoder();
		return encoder.encode(data.toByteArray());
	}

	public static boolean base64ToImage(String imgStr, String imgFilePath) { // 对字节数组字符串进行Base64解码并生成图片

		if (StringUtils.isEmpty(imgStr)) { // 图像数据为空
			return false;
		}

		BASE64Decoder decoder = new BASE64Decoder();
		try {
			// Base64解码
			byte[] b = decoder.decodeBuffer(imgStr);
			for (int i = 0; i < b.length; ++i) {
				if (b[i] < 0) {// 调整异常数据
					b[i] += 256;
				}
			}

			OutputStream out = new FileOutputStream(imgFilePath);
			out.write(b);
			out.flush();
			out.close();

			return true;
		} catch (Exception e) {
			return false;
		}

	}


	/**
	 * 下载远程文件到本地
	 * @param remoteFilePath 文件路径
	 * @param localFilePath 保存本地路径
	 */
	public void downloadFile(String remoteFilePath, String localFilePath) throws Exception{
		URL urlfile = null;
		HttpURLConnection httpUrl = null;
		BufferedInputStream bis = null;
		BufferedOutputStream bos = null;
		File f = new File(localFilePath);
		try{
			if(!f.getParentFile().exists()){
				f.getParentFile().mkdirs();
			}
			urlfile = new URL(remoteFilePath);
			httpUrl = (HttpURLConnection)urlfile.openConnection();
			httpUrl.connect();
			bis = new BufferedInputStream(httpUrl.getInputStream());
			bos = new BufferedOutputStream(new FileOutputStream(f));
			int len = 2048;
			byte[] b = new byte[len];
			while ((len = bis.read(b)) != -1){
				bos.write(b, 0, len);
			}
			bos.flush();
			bis.close();
			httpUrl.disconnect();
		}catch (Exception e){
			logger.error("图片下载失败:{}",remoteFilePath);
		}finally{
			try{
				bis.close();
				bos.close();
			}catch (IOException e){
				e.printStackTrace();
			}
		}
	}

}