package com.bcxin.obpm.ministerial;


import com.bcxin.obpm.annotation.MinisterialAttr;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;

/**
 * 服务公司管理层信息职务
 * @author zhangyutong
 */
@Component
public class JobTypeMinDataFormatStrategy implements MinDataFormatStrategy{
    @Override
    public String format(Field columnField, Object data) {
        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }
        String[] datas=String.valueOf(data).split(";");
        String rt="";
        for (String str:datas
             ) {
            switch (String.valueOf(str)) {
                case "1" :
                   rt+="总经理/";
                   break;
                case "2" :
                    rt+="副总经理/";
                    break;
                case "3" :
                    rt+="法定代表人/";
                    break;
                case "4" :
                    rt+="实际负责人/";
                    break;
            }

        }
        if (rt.length()>0){
            return rt.substring(0,rt.length()-1);
        }else {
            return "";
        }
    }

   /* public static void main(String[] args) {
        String[] datas="5".split(";");
        String rt="";
        for (String str:datas
        ) {
            switch (String.valueOf(str)) {
                case "1" :
                    rt+="总经理/";
                    break;
                case "2" :
                    rt+="副总经理/";
                    break;
                case "3" :
                    rt+="法定代表人/";
                    break;
                case "4" :
                    rt+="实际负责人/";
                    break;
            }

        }
        if (rt.length()>0){
            System.out.println(rt.substring(0,rt.length()-1));
        }else {
            System.out.println("");
        }

    }*/
}
