/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendCalendar;
import com.bcxin.platform.mapper.attend.AttendCalendarMapper;
import com.bcxin.platform.mapper.attend.AttendCalendarRestDetailMapper;
import com.bcxin.platform.mapper.attend.AttendCalendarRestMapper;
import com.bcxin.platform.mapper.company.PerOrgRelationMapper;
import com.bcxin.platform.service.attend.AttendCalendarService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class AttendCalendarServiceImpl
implements AttendCalendarService {
    @Autowired
    private AttendCalendarMapper attendCalendarMapper;
    @Autowired
    private AttendCalendarRestMapper attendCalendarRestMapper;
    @Autowired
    private AttendCalendarRestDetailMapper attendCalendarRestDetailMapper;
    @Autowired
    private PerOrgRelationMapper perOrgRelationMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public AttendCalendar findById(Long id) {
        return this.attendCalendarMapper.findById(id);
    }

    @Override
    public List<AttendCalendar> selectList(AttendCalendar searchDto) {
        if (!(searchDto.isDomainAdmin() || searchDto.getAdminDepartIds() != null && searchDto.getAdminDepartIds().size() != 0)) {
            return new ArrayList<AttendCalendar>();
        }
        return this.attendCalendarMapper.selectList(searchDto);
    }

    @Override
    public int update(AttendCalendar attendCalendar) {
        AttendCalendar dbAttendCalendar = this.attendCalendarMapper.findByName(attendCalendar.getCalendarName());
        if (dbAttendCalendar != null && !dbAttendCalendar.getId().equals(attendCalendar.getId())) {
            throw new BusinessException("\u65e5\u5386\u5957\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        if (attendCalendar.getId() == null) {
            attendCalendar.setCreateTime(DateUtils.getNowDate());
            attendCalendar.setId(this.idWorker.nextId());
            attendCalendar.setIsDelete("0");
        } else {
            dbAttendCalendar = this.attendCalendarMapper.findById(attendCalendar.getId());
            BeanUtils.copyPropertiesIgnore((Object)((Object)attendCalendar), (Object)((Object)dbAttendCalendar), (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)((Object)dbAttendCalendar), (Object)((Object)attendCalendar), (Boolean)false);
        }
        attendCalendar.setUpdateTime(DateUtils.getNowDate());
        return this.attendCalendarMapper.save(attendCalendar);
    }

    @Override
    public int deleteByIds(String ids) {
        this.attendCalendarRestMapper.deleteByCalendarIds(Convert.toStrArray((String)ids));
        this.attendCalendarRestDetailMapper.deleteByCalendarIds(Convert.toStrArray((String)ids));
        return this.attendCalendarMapper.deleteByIds(Convert.toStrArray((String)ids));
    }
}

