/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.util;

import java.io.PrintWriter;
import java.io.StringWriter;

public final class ExceptionUtils {
    public static <T extends Exception> T cast(Exception ex, Class<T> targetClass) {
        assert (ex != null);
        if (!targetClass.isAssignableFrom(ex.getClass())) {
            return null;
        }
        return (T)ex;
    }

    public static <T extends Exception> boolean is(Exception ex, Class<T> targetClass) {
        assert (ex != null);
        return targetClass.isAssignableFrom(ex.getClass());
    }

    public static String getStackMessage(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            throwable.printStackTrace(pw);
        }
        return sw.toString();
    }
}

