package com.bcxin.platform.web.controller.company;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.ComDepart;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.company.ComDepartDto;
import com.bcxin.platform.service.company.ComDepartService;
import com.bcxin.platform.service.company.PerOrgRelationService;
import com.bcxin.platform.util.log.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 部门Controller
 * 
 * @author task
 * @date 2021-04-09
 */
@RestController
@RequestMapping("/depart")
@Api(tags = { "" }, description = "V5-部门信息")
public class ComDepartController extends BaseController{

    @Autowired
    private ComDepartService comDepartService;

    @Autowired
    private PerOrgRelationService perOrgRelationService;

    /**
     * 查询部门列表
     */
    @PostMapping("/list")
    public TableDataInfo list(ComDepart comDepart){
        startPage();
        List<ComDepart> list = comDepartService.selectComDepartList(comDepart);
        return getDataTable(list);
    }

    /**
     * 新增修改保存部门
     */
    @Log(title = "新增修改部门", modle = "部门管理", operation = Log.OPERA_TYPE_UPDATE, systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @ApiOperation(value = "新增修改部门", httpMethod = "POST", notes = "新增修改部门")
    @PostMapping("/edit")
    public AjaxResult editSave(ComDepart comDepart){
        return toAjax(comDepartService.updateComDepart(comDepart));
    }

    /**
     * 新增修改保存部门
     */
    @Log(title = "新增修改部门(批量)", modle = "部门管理", operation = Log.OPERA_TYPE_UPDATE, systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @ApiOperation(value = "新增修改部门(批量)", httpMethod = "POST", notes = "新增修改部门")
    @PostMapping("/editBatch")
    public AjaxResult editBatch(String tklComId,String comDeparts){
        List<ComDepart> list = JSONArray.parseArray(comDeparts,ComDepart.class);
        return toAjax(comDepartService.editBatch(tklComId,list));
    }

    /**
     * 删除部门
     */
    @Log(title = "删除部门", modle = "部门管理", operation = Log.OPERA_TYPE_DEL, systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @ApiOperation(value = "删除部门", httpMethod = "POST", notes = "删除部门")
    @PostMapping( "/remove")
    public AjaxResult remove(String ids){
        return toAjax(comDepartService.deleteComDepartByIds(ids));
    }


    /**
     * 人事模块-组织架构部门树（新）
     * @param comDepart
     * @auth llc
     * @date 2019-07-16
     * @return
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "部门人员树型", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "get-depart-tree")
    public Result getDepartTree(ComDepartDto comDepart) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        comDepart.setPerID(currentUser.getPerId());
        return comDepartService.getDepartTree(comDepart).setBack(getRequest());
    }


    /**
     * 获取驻勤模块公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2020-04-16
     * @return
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "获取驻勤模块公共部门树的人员列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "get-task-depart-person-list")
    public Result getTaskDepartPerSonList(ComDepartDto comDepart) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        return perOrgRelationService.getTaskDepartPerSonList(comDepart).setBack(getRequest());
    }

    /**
     * 选人公共部门树接口
     * @param comDepart
     * @auth llc
     * @date 2019-08-28
     * @return
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "部门树型", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "get-tree-depart")
    public Result getTreeDepart(ComDepartDto comDepart) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        return comDepartService.getTreeDepart(comDepart).setBack(getRequest());
    }

    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "部门树型", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @GetMapping(value = "get-tree-depart-not-data-auth")
    public Result getTreeDepartNotDataAuth(ComDepartDto comDepart) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        comDepart.setComId(currentUser.getComId());
        return comDepartService.getTreeDepartNotDataAuth(comDepart).setBack(getRequest());
    }

    /**
     * 获取选人公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2019-08-28
     * @return
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "获取组织机构右边的人员列表", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "get-depart-person-list")
    public Result getDepartPerSonList(ComDepartDto comDepart) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        return perOrgRelationService.getDepartPerSonList(comDepart).setBack(getRequest());
    }

    /**
     * 公共选人的接口(关键字查询)
     * @param comDepartDto
     * @return
     * @author llc
     * @date 2019-08-28
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "公共选人的接口(关键字查询)", systemType = Log.SYSTEMTYPE_PHONE)
    @PostMapping(value = "get-common-per-list-by-keyword")
    @ApiOperation(value = "公共选人的接口(关键字查询)", httpMethod = "POST", notes = "公共选人的接口(关键字查询)")
    public Result getCommonPerListByKeyword(ComDepartDto comDepartDto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        Result result = perOrgRelationService.getCommonPerListByKeyword(comDepartDto);
        return result;
    }

    /**
     * 获取华为会议选人公共部门树的人员列表
     * @param comDepart
     * @auth llc
     * @date 2019-12-12
     * @return
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "部门管理", title = "获取组织机构右边的人员列表（华为会议选人）", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "get-huawei-depart-person-list")
    public Result getHuaweiDepartPerSonList(ComDepartDto comDepart) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        return perOrgRelationService.getHuaweiDepartPerSonList(comDepart).setBack(getRequest());
    }
}
