package com.bcxin.platform.web.controller.attend;

import com.bcxin.oaflow.dto.OaBusinessDto;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.dto.attend.AttendReportDto;
import com.bcxin.platform.service.attend.AttendReportService;
import com.bcxin.platform.timer.AttendReportTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 考勤结果统计Controller
 * 
 * @author lin
 * @date 2021-08-30
 */
@RestController
@RequestMapping("/attend/report")
public class AttendReportController extends BaseController{

    @Autowired
    private AttendReportService attendReportService;

    @Autowired
    private AttendReportTask attendReportTask;

    /**
     * 查询考勤结果统计列表
     */
    @PostMapping("/searchForPage")
    public TableDataInfo searchForPage(AttendReportDto attendReport){
        startPage();
        List<AttendReportDto> list = attendReportService.selectList(attendReport);
        return getDataTable(list);
    }


    /**
     * 根据主键id查询
     */
    @GetMapping("/findById/{id}")
    public AjaxResult findById(@PathVariable("id") Long id){
        AttendReportDto attendReport = attendReportService.findById(id);
        return AjaxResult.success(null,attendReport);
    }

    /**
     * 根据主键id查询
     */
    @GetMapping("/findDetail/{id}")
    public AjaxResult findDetail(@PathVariable("id") Long id){
        AttendReportDto attendReport = attendReportService.findDetail(id);
        return AjaxResult.success(null,attendReport);
    }

    /**
     * 审批通过 更新结果统计
     */
    @PostMapping("/updateForOA")
    public AjaxResult updateReport(OaBusinessDto searchDto){
        attendReportTask.updateReportForOA(searchDto);
        return AjaxResult.success();
    }
}
