package com.bcxin.platform.web.controller.app.attend;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.utils.validator.ValidatorUtils;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.FactorGroup;
import com.bcxin.platform.dto.app.AppAttendSchedulDto;
import com.bcxin.platform.dto.attend.AttendSchedulDto;
import com.bcxin.platform.service.attend.AttendSchedulService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * 考勤排班Controller
 * 
 * @author lin
 * @date 2021-08-10
 */
@RestController
@RequestMapping("/app/attend/schedul")
public class AppAttendSchedulController extends BaseController{


    @Autowired
    private AttendSchedulService attendSchedulService;

    /**
     * 保存考勤排班
     */
    @Log(title = "考勤排班", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    public AjaxResult save(AttendSchedulDto attendSchedul){
        attendSchedul.setNeedCalendar(Constants.N);
        attendSchedul.setEndDate(attendSchedul.getStartDate());
        ValidatorUtils.validateEntity(attendSchedul, AddGroup.class);
        attendSchedul.setRemoveOld(true);
        return toAjax(attendSchedulService.save(attendSchedul));
    }

    /**
     * 保存考勤排班
     */
    @Log(title = "考勤排班保存", businessType = BusinessType.UPDATE)
    @PostMapping("/saveForWeeks")
    public AjaxResult saveForWeeks(AttendSchedulDto attendSchedul){
        attendSchedul.setNeedCalendar(Constants.N);
        ValidatorUtils.validateEntity(attendSchedul, AddGroup.class);
        ValidatorUtils.validateEntity(attendSchedul, FactorGroup.class);
        return attendSchedulService.saveForWeeks(attendSchedul);
    }
    /**
     * 排班详情
     */
    @Log(title = "排班详情", businessType = BusinessType.OTHER)
    @PostMapping("/monthDetail")
    public AjaxResult monthDetail(@Valid AppAttendSchedulDto searchDto){
        return AjaxResult.success(attendSchedulService.monthDetail(searchDto));
    }
}
