package com.bcxin.platform.web.controller.app.attend;

import cn.hutool.core.util.StrUtil;
import com.bcxin.platform.common.constant.DictConst;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.app.AppAttendSearchDto;
import com.bcxin.platform.dto.attend.AttendReportDto;
import com.bcxin.platform.service.attend.AttendReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 考勤结果统计Controller
 * 
 * @author lin
 * @date 2021-08-30
 */
@RestController
@RequestMapping("/app/attend/report")
public class AppAttendReportController extends BaseController{

    @Autowired
    private AttendReportService attendReportService;

    /**
     * 查询考勤结果统计列表
     */
    @PostMapping("/searchForPage")
    public TableDataInfo searchForPage(AttendReportDto attendReport){
        startPage();
        List<AttendReportDto> list = attendReportService.selectList(attendReport);
        return getDataTable(list);
    }

    /**
     * 我的统计
     */
    @RequestMapping("/findMonthStatistics")
    public AjaxResult findMonth(AppAttendSearchDto searchDto){
        CurrentUser currentUser = new CurrentUser(getRequest());
        searchDto.setPerId(currentUser.getPerId());
        if(StrUtil.isEmpty(searchDto.getSchedulDate())){
            searchDto.setSchedulDate(DateUtils.dateTimeNow(DateUtils.YYYY_MM));
        }
        searchDto.setAttendReportType(DictConst.ATTENDREPORTTYPE_MONTH);
        return AjaxResult.success(attendReportService.findMonthStatistics(searchDto));
    }

    /**
     * 保安员月考勤统计
     */
    @RequestMapping("/findMonthStatisticsForPer")
    public AjaxResult findMonthForPer(AppAttendSearchDto searchDto){
        if(StrUtil.isEmpty(searchDto.getSchedulDate())){
            searchDto.setSchedulDate(DateUtils.dateTimeNow(DateUtils.YYYY_MM));
        }
        searchDto.setAttendReportType(DictConst.ATTENDREPORTTYPE_MONTH);
        return AjaxResult.success(attendReportService.findMonthStatistics(searchDto));
    }

}
