var sysRegionUtil = {
    getRegionOption:function(objid,regionLevel,parentRegionId){
        var loadAreaIndex = layer.load(0, {shade: [0.3, '#808080']});
        var defaultValue = $("#"+objid).attr("default-value");
        $("#"+objid).empty();
        $("#"+objid).append('<option value="">--请选择--</option>');
        $.ajax({
            url: ctx +"region/list",
            data: {
                "regionLevel":regionLevel,
                "parentRegionId":parentRegionId
            },
            dataType: "json",
            cache: false,
            async : false,
            type: 'POST',
            success: function (result) {
                if(result){
                    $.each(result, function (i, obj) {
                        if(obj.regionId == defaultValue){
                            $("#"+objid).append('<option value="'+obj.regionId+'" selected="selected">'+obj.regionName+'</option>');
                        }else{
                            $("#"+objid).append('<option value="'+obj.regionId+'">'+obj.regionName+'</option>');
                        }
                    });
                }
                layer.close(loadAreaIndex);
            }
        });
    }
}


$(function(){
    sysRegionUtil.getRegionOption("province","1",null);
    if($("#province").val() != ""){
        sysRegionUtil.getRegionOption("city",null,$("#province").val());
        if($("#city").val() != ""){
            sysRegionUtil.getRegionOption("area",null,$("#city").val());
        }
    }
})

$('#province').change(function() {
    var province = this.value;
    if(province != ""){
        sysRegionUtil.getRegionOption("city",null,province);
        $("#area").empty().append("<option value=\"\">--请选择--</option>");
    }else{
        $("#city").empty().append("<option value=\"\">--请选择--</option>");
        $("#area").empty().append("<option value=\"\">--请选择--</option>");
    }
});

$('#city').change(function() {
    var city = this.value;
    if(city != ""){
        sysRegionUtil.getRegionOption("area",null,city);
    }else{
        $("#area").empty().append("<option value=\"\">--请选择--</option>");
    }
});