

/*最大金额 不限选项控制*/
$('input[name=unlimited]').on('ifUnchecked', function (event) {
    $("#maxAmount").prop('readonly', false);
    $("#maxAmount").attr('required',"required");
});
$('input[name=unlimited]').on('ifChecked', function (event) {
    $("#maxAmount").prop('readonly', true);
    $("#maxAmount").removeAttr('required');
    $("#maxAmount").val("");
});

/**
 * 是否含税 选项变更
 */
function changeIsIncludTax() {
    $("#calculateFormula").val("");
    var isIncludTax = $("#isIncludTax").val();
    if(isIncludTax == "Y"){
        $("#taxRate").parent().parent().show();
        $("#calculateFormula").val("(收付金额 / (1 + 税率) - 克扣金额) * 计算比例");
    }else if(isIncludTax == "N"){
        $("#taxRate").val("").parent().parent().hide();
        $("#calculateFormula").val("(收付金额 - 克扣金额)*计算比例");
    }
}


/**
 * 计算公式校验
 */
function checkCalculateFormula(formId){
    $("#result").html("").hide();

    if(!validatePlanForm()){
        return;
    }

    var payAmount = $("#payAmount").val();
    var maxAmount = $("#maxAmount").val();
    var minAmount = $("#minAmount").val();

    if(payAmount ==""){
        $.modal.alertError("请输入收付金额");
        return;
    }

    if($("input[name=unlimited]").is(':checked')){
        if(payAmount !="" && parseInt(payAmount)<parseInt(minAmount)){
            $.modal.alertError("收付金额需在金额上下限内");
            return;
        }
    }else{
        if(payAmount !="" && (parseInt(payAmount)<parseInt(minAmount) || parseInt(payAmount)>parseInt(maxAmount))){
            $.modal.alertError("收付金额需在金额上下限内");
            return;
        }
    }


    var config = {
        url: ctx + "basePlan/checkCalculateFormula",
        type: "post",
        dataType: "json",
        data: $('#'+formId).serialize(),
        beforeSend: function () {
            $.modal.loading("正在处理中，请稍后...");
        },
        success: function(result) {
            if (result.code == web_status.SUCCESS) {
                $("#result").html("结算金额="+result.data).show();
            }else if (result.code == web_status.WARNING) {
                $.modal.alertWarning(result.msg)
            }  else {
                $.modal.alertError(result.msg);
            }
            $.modal.closeLoading();
        }
    };
    $.ajax(config);
}

/**
 * 计划表单校验
 * @returns {boolean}
 */
function validatePlanForm() {
    var flag = true;
    if ($.validate.form()) {
        var maxAmount = $("#maxAmount").val();
        var minAmount = $("#minAmount").val();
        if($("input[name=unlimited]").is(':checked')){

        }else{
            if(parseInt(maxAmount)<parseInt(minAmount)){
                $.modal.alertError("金额上限须大于等于金额下限");
                flag = false;
            }
        }
    }else{
        flag = false;
    }
    return flag;

}