package com.bcxin.platform.web.controller.order;

import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.order.ComOrderDto;
import com.bcxin.platform.service.order.ComOrderService;
import com.bcxin.platform.util.log.Log;
import com.bcxin.platform.web.controller.base.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 企业订单的controller层
 * by llc 2020-01-15
 */
@RestController
@RequestMapping("/order/com-order")
@Api(tags = { "" }, description = "企业订单")
public class ComOrderController extends BaseController {

	@Autowired
	private ComOrderService comOrderService;



	/**
	 * 校验订单
	 * @return
	 * @author llc
	 * @date 2020-01-20
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业订单", title = "校验订单", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "校验订单", httpMethod = "POST", notes = "校验订单", response = Result.class)
	@PostMapping(value = "check-order")
	public Result checkOrder(ComOrderDto dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comOrderService.checkOrder(dto).setBack(getRequest());
	}


	/**
	 * 提交订单
	 * @return
	 * @author llc
	 * @date 2020-01-15
	 */
	@PostMapping(value = "save-order")
	public Result saveOrder(ComOrderDto dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comOrderService.saveOrder(dto).setBack(getRequest());
	}


	/**
	 * 获取订单列表
	 * @return
	 * @author llc
	 * @date 2020-01-15
	 */
	@PostMapping(value = "get-order-list")
	public Result getOrderList(ComOrderDto dto) {
		return comOrderService.getOrderList(dto);
	}

}
