package com.bcxin.platform.web.controller.meeting;

import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.meeting.ComHuaweiMeetMatch;
import com.bcxin.platform.domain.meeting.PerHuaweiMeetMatch;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.meeting.ModVmrDto;
import com.bcxin.platform.dto.meeting.PerHuaweiMeetMatchDto;
import com.bcxin.platform.dto.meeting.RestScheduleConfDTO;
import com.bcxin.platform.service.meeting.ComHuaweiMeetMatchService;
import com.bcxin.platform.util.log.Log;
import com.bcxin.platform.web.controller.base.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.Map;

/**
 * 企业华为云会议映射
 *
 * @author llc
 * @date 2019-12-11
 */
@RestController
@Api("企业华为云会议映射")
@RequestMapping("/com-huawei-meet-match")
public class ComHuaweiMeetMatchController extends BaseController {

    @Resource
    private ComHuaweiMeetMatchService comHuaweiMeetMatchService;


    /**
     * 获取企业华为云会议映射
     *
     * @param comHuaweiMeetMatch
     * @return
     * @auth llc
     * @date 2019-12-24
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业华为云会议映射", title = "获取企业华为云会议映射", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "get-com-huawei-meet")
    @ApiOperation(value = "获取企业华为云会议映射", httpMethod = "POST", notes = "获取企业华为云会议映射", response = ComHuaweiMeetMatch.class)
    public Result getComHuaweiMeet(ComHuaweiMeetMatch comHuaweiMeetMatch) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        return comHuaweiMeetMatchService.getComHuaweiMeet(comHuaweiMeetMatch).setBack(getRequest());
    }

    /**
     * 获取企业华为云会议管理资源
     *
     * @param perHuaweiMeetMatch
     * @return
     * @auth llc
     * @date 2019-12-10
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业华为云会议映射", title = "获取企业华为云会议管理资源", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "get-huawei-manage-resource")
    @ApiOperation(value = "获取企业华为云会议管理资源", httpMethod = "POST", notes = "获取企业华为云会议管理资源", response = Map.class)
    public Result getHuaweiManageResource(PerHuaweiMeetMatch perHuaweiMeetMatch) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        perHuaweiMeetMatch.setPerId(currentUser.getPerId());
        return comHuaweiMeetMatchService.getHuaweiManageResource(perHuaweiMeetMatch).setBack(getRequest());
    }


    /**
     * <b> 预约会议 </b>
     *
     * @author ZXF
     * @create 2020/01/13 0013 17:27
     * @version
     * @注意事项 </b>
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "预约会议", title = "管理员或普通用户可以通过该接口创建会议", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "build-huawei-meet")
    @ApiOperation(value = "管理员或普通用户可以通过该接口创建会议", httpMethod = "POST", notes = "管理员或普通用户可以通过该接口创建会议", response = Map.class)
    public Result buildHuaweiMeet(RestScheduleConfDTO restScheduleConfDTO) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        restScheduleConfDTO.setPerId(currentUser.getPerId());
        return comHuaweiMeetMatchService.buildHuaweiMeet(restScheduleConfDTO).setBack(getRequest());
    }

    /**
     * <b> 预约会议 </b>
     *
     * @author ZXF
     * @create 2020/01/13 0013 17:27
     * @version
     * @注意事项 </b>
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "预约会议", title = "用户查询自己的信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "get-huawei-user-detail")
    @ApiOperation(value = "用户查询自己的信息", httpMethod = "POST", notes = "用户查询自己的信息", response = Map.class)
    public Result getHuaweiUserDetail(PerHuaweiMeetMatch perHuaweiMeetMatch) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        perHuaweiMeetMatch.setPerId(currentUser.getPerId());
        return comHuaweiMeetMatchService.getHuaweiUserDetail(perHuaweiMeetMatch).setBack(getRequest());
    }


    /**
     * 获取企业华为专用云会议室
     *
     * @param dto
     * @return
     * @auth llc
     * @date 2020-02-17
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业华为云会议映射", title = "获取企业华为专用云会议室", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "get-huawei-cloud-meet-room-list")
    @ApiOperation(value = "获取企业华为专用云会议室", httpMethod = "POST", notes = "获取企业华为专用云会议室", response = Map.class)
    public Result getHuaweiCloudMeetRoomList(PerHuaweiMeetMatchDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        dto.setPerId(currentUser.getPerId());
        return comHuaweiMeetMatchService.getHuaweiCloudMeetRoomList(dto).setBack(getRequest());
    }

    /**
     * <b> 修改用户云会议室 </b>
     *
     * @author ZXF
     * @create 2020/02/19 0019 10:50
     * @version
     * @注意事项 </b>
     */
    @Log(operation = Log.OPERA_TYPE_UPDATE, modle = "云会议室管理", title = "修改用户云会议室", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "update-huawei-cloud-member-vmr")
    @ApiOperation(value = "修改用户云会议室", httpMethod = "POST", notes = "修改用户云会议室", response = Map.class)
    public Result updateHuaweiCloudMemberVmr(ModVmrDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        dto.setPerId(currentUser.getPerId());
        return comHuaweiMeetMatchService.updateHuaweiCloudMemberVmr(dto).setBack(getRequest());
    }

    /**
     * <b> 回收专用云会议室 </b>
     *
     * @author ZXF
     * @create 2020/02/19 0019 10:50
     * @version
     * @注意事项 </b>
     */
    @Log(operation = Log.OPERA_TYPE_UPDATE, modle = "云会议室管理", title = "回收专用云会议室", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "recycle-from-member")
    @ApiOperation(value = "回收专用云会议室", httpMethod = "POST", notes = "回收专用云会议室", response = Map.class)
    public Result recycleFromMember(ModVmrDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        dto.setPerId(currentUser.getPerId());
        return comHuaweiMeetMatchService.recycleFromMember(dto).setBack(getRequest());
    }

    /**
     * <b> 分配专用云会议室 </b>
     *
     * @author ZXF
     * @create 2020/02/19 0019 10:50
     * @version
     * @注意事项 </b>
     */
    @Log(operation = Log.OPERA_TYPE_UPDATE, modle = "云会议室管理", title = "分配专用云会议室", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "assign-to-member")
    @ApiOperation(value = "分配专用云会议室", httpMethod = "POST", notes = "分配专用云会议室", response = Map.class)
    public Result assignToMember(ModVmrDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        dto.setPerId(currentUser.getPerId());
        return comHuaweiMeetMatchService.assignToMember(dto).setBack(getRequest());
    }

    /**
     * <b> 删除专用云会议室 </b>
     *
     * @author ZXF
     * @create 2020/02/19 0019 10:50
     * @version
     * @注意事项 </b>
     */
    @Log(operation = Log.OPERA_TYPE_UPDATE, modle = "云会议室管理", title = "删除专用云会议室", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "delete-member-vmr")
    @ApiOperation(value = "删除专用云会议室", httpMethod = "POST", notes = "删除专用云会议室", response = Map.class)
    public Result deleteMemberVmr(ModVmrDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        dto.setPerId(currentUser.getPerId());
        return comHuaweiMeetMatchService.deleteMemberVmr(dto).setBack(getRequest());
    }

    /**
     * <b> 分页查询用户云会议室 </b>
     *
     * @author ZXF
     * @create 2020/02/20 0020 10:44
     * @version
     * @注意事项 </b>
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "云会议室管理", title = "分页查询用户云会议室", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "get-huawei-cloud-member-vmr-list")
    @ApiOperation(value = "分页查询用户云会议室", httpMethod = "POST", notes = "分页查询用户云会议室", response = Map.class)
    public Result getHuaweiCloudMemberVmrList(ModVmrDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        dto.setPerId(currentUser.getPerId());
        return comHuaweiMeetMatchService.getHuaweiCloudMemberVmrList(dto).setBack(getRequest());
    }

}
