package com.bcxin.platform.web.controller.manage.bhaccount;

import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.dto.grant.ComBhAccountDTO;
import com.bcxin.platform.service.grant.ComBhAccountService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

/**
 * <b> 企业渤海账户 </b>
 * @author ZXF
 * @create 2020/09/15 0015 14:43
 * @version
 * @注意事项 </b>
 */
@Controller
@RequestMapping("/manage/bh-account")
public class ComBhAccountManageController extends BaseController {

    private String prefix = "manage/bh-account";


    @Autowired
    private ComBhAccountService comBhAccountService;

    /**
     * <b> 企业渤海账户列表页 </b>
     * @author ZXF
     * @create 2020/08/17 0017 14:33
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("bh-account:view")
    @GetMapping("/view-com-bh-account-list")
    public String comBhAccountView() {
        return prefix + "/comBhAccountList";
    }

    @RequiresPermissions("bh-account:view")
    @GetMapping("/account-info-view/{comId}")
    public String accountInfoView(@PathVariable("comId") String comId, ModelMap mmap) {
        mmap.put("comBhAccount", comBhAccountService.getComBhAccount(comId));
        return prefix + "/accountInfo";
    }

    @RequiresPermissions("bh-account:view")
    @GetMapping("/payment-details-view")
    public String paymentDetailsView() {
        return prefix + "/paymentDetails";
    }

    /**
     * <b> 企业渤海账户列表查询 </b>
     * @author ZXF
     * @create 2020/08/17 0017 14:38
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("bh-account:list")
    @PostMapping("/page-com-bh-account-list")
    @ResponseBody
    public Object comBhAccountList(ComBhAccountDTO dto) {
        startPage();
        return getDataTable(comBhAccountService.pageComBhAccountList(dto));
    }

    /**
     * <b> 企业渤海账户列表查询 </b>
     * @author ZXF
     * @create 2020/08/17 0017 14:38
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("bh-account:list")
    @PostMapping("/page-payment-details-list")
    @ResponseBody
    public Object paymentDetailsList(ComBhAccountDTO dto) throws V5BusinessException {
        startPage();
        return getDataTable(comBhAccountService.pagePaymentDetailsList(dto));
    }

    /**
     * <b> 修改发薪权限 </b>
     * @author ZXF
     * @create 2020/09/16 0016 13:31
     * @version
     * @注意事项 </b>
     */
    @RequiresPermissions("bh-account:list")
    @PostMapping("/update-open-salary-auth")
    @ResponseBody
    public Result updateOpenSalaryAuth(ComBhAccountDTO dto) {
        return comBhAccountService.updateOpenSalaryAuth(dto);
    }
}
