package com.bcxin.platform.web.controller.manage;


import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.exception.PlatFormBusinessException;
import com.bcxin.platform.common.utils.poi.ExcelUtil;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.domain.meeting.ComHuaweiMeetMatch;
import com.bcxin.platform.dto.meeting.ComHuaweiMeetMatchDto;
import com.bcxin.platform.dto.order.ComOrderDto;
import com.bcxin.platform.service.company.ComBaseInfoService;
import com.bcxin.platform.service.meeting.ComHuaweiMeetMatchService;
import com.bcxin.platform.service.order.ComOrderService;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 云会议企业Controller
 *
 * @author lin
 * @date 2021-06-21
 */
@Controller
@RequestMapping("/manage/meeting")
public class ComMeetingController extends BaseController {

    private String prefix = "manage/meeting";

    @Autowired
    private ComHuaweiMeetMatchService comHuaweiMeetMatchService;

    @Autowired
    private ComBaseInfoService comBaseInfoService;

    @Autowired
    private ComOrderService comOrderService;

    @RequiresPermissions("meeting:view")
    @GetMapping()
    public String meeting(){
        return prefix + "/meeting";
    }

    /**
     * 查询企业华为云会议映射列表
     */
    @RequiresPermissions("meeting:list")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(ComHuaweiMeetMatchDto comHuaweiMeetMatch){
        startPage();
        List<ComHuaweiMeetMatchDto> list = comHuaweiMeetMatchService.selectComHuaweiMeetMatchList(comHuaweiMeetMatch);
        return getDataTable(list);
    }

    /**
     * 导出企业华为云会议映射列表
     */
    @RequiresPermissions("meeting:export")
    @Log(title = "企业华为云会议映射", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    @ResponseBody
    public AjaxResult export(ComHuaweiMeetMatchDto comHuaweiMeetMatch){
        List<ComHuaweiMeetMatchDto> list = comHuaweiMeetMatchService.selectComHuaweiMeetMatchList(comHuaweiMeetMatch);
        ExcelUtil<ComHuaweiMeetMatchDto> util = new ExcelUtil<ComHuaweiMeetMatchDto>(ComHuaweiMeetMatchDto.class);
        return util.exportExcel(list, "meeting");
    }

    /**
     * 新增企业华为云会议映射
     */
    @GetMapping("/add")
    public String add(ComBaseInfo comBaseInfo, ModelMap mmap){
        mmap.put("comList", comBaseInfoService.selectComBaseInfoList(comBaseInfo));
        return prefix + "/add";
    }

    /**
     * 新增保存企业华为云会议映射
     */
    @RequiresPermissions("meeting:add")
    @Log(title = "企业华为云会议映射", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    @ResponseBody
    public AjaxResult addSave(ComHuaweiMeetMatch comHuaweiMeetMatch) throws Exception {
        return toAjax(comHuaweiMeetMatchService.saveComHuaweiMeetMatch(comHuaweiMeetMatch));
    }

    /**
     * 刷新登录
     */
    @RequiresPermissions("meeting:edit")
    @Log(title = "企业华为云会议映射", businessType = BusinessType.UPDATE)
    @PostMapping("/refreshLogin/{comId}")
    @ResponseBody
    public AjaxResult refreshLogin(@PathVariable("comId")Long comId){
        return toAjax(comHuaweiMeetMatchService.refreshComHuaweiMeet(comId));
    }

    /**
     * 删除企业华为云会议映射
     */
    @RequiresPermissions("meeting:remove")
    @Log(title = "企业华为云会议映射", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    @ResponseBody
    public AjaxResult remove(String ids){
        return toAjax(comHuaweiMeetMatchService.deleteComHuaweiMeetMatchByIds(ids));
    }


    /**
     * 查看企业华为云会议映射
     */
    @GetMapping("/view/{comId}")
    public String view(@PathVariable("comId") Long comId, ModelMap mmap){
        ComBaseInfo company = comBaseInfoService.selectComBaseInfoById(comId);
        mmap.put("company", company);
        return prefix + "/view";
    }

    /**
     * <b> 根据被分配机构id查询资源列 </b>
     * @author ZXF
     * @create 2020/05/25 0025 16:08
     * @version
     * @注意事项 </b>
     */
    @PostMapping(value = "reasource-list")
    @ApiOperation(value = "查询企业资源", httpMethod = "POST", notes = "查询企业资源", response = ComOrderDto.class)
    @ResponseBody
    public TableDataInfo getOrderDetailListByAssignedOrgId(ComOrderDto dto) throws PlatFormBusinessException {
        List<Map<String,String>> list = comOrderService.getOrderDetailListByAssignedOrgId(dto);
        return getDataTable(list);

    }

}
