package com.bcxin.platform.web.controller.insurance.callback;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.blb.AjaxResult;
import com.bcxin.platform.dto.insurance.BLBAPIDTO;
import com.bcxin.platform.dto.insurance.ComInsDTO;
import com.bcxin.platform.service.insurance.ComInsService;
import com.bcxin.platform.util.BLBSyncDataException;
import com.bcxin.platform.util.log.Log;
import com.bcxin.platform.web.controller.base.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 陈堂君
 * <p>
 * 类描述:
 * <p>
 * 
 * @apiNote 作者 陈堂君
 * @since 创建于 2018/1/4 13:24
 */
@RestController
@RequestMapping("/enterprise/blb-api-controller")
@Api(tags = { "" }, description = "百联保调用的接口") // tag中文会影响路径
public class BLBAPIController extends BaseController {

	@Autowired
	private ComInsService comInsService;

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "百联保调用的接口", title = "根据企业ID获取企业的和人员的信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping("/find-compnay-person-by-user-id")
	@ApiOperation(value = "根据企业ID获取企业的和人员的信息")
	public AjaxResult findCompnayAndPersonByUserid(ComInsDTO dto) throws V5BusinessException {
		return comInsService.findCompnayAndPersonByUserid(dto);
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "百联保调用的接口", title = "根据缓存ID获得对应的保全人员信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping("/find-perIds-by-cache-id")
	@ApiOperation(value = "根据缓存ID获得对应的保全人员信息")
	public AjaxResult findPerIdsByCacheId(ComInsDTO dto) throws V5BusinessException {
		return comInsService.findPerIdsByCacheId(dto);
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "百联保调用的接口", title = "根据缓存ID获得已选择的人员信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@GetMapping("/find-compnay-person-by-cache-id")
	@ApiOperation(value = "根据缓存ID获得已选择的人员信息")
	public Result findCompnayAndPersonByCacheId(ComInsDTO dto) throws V5BusinessException {
		return comInsService.findCompnayAndPersonByCacheId(dto);
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "百联保调用的接口", title = "订单信息回传的接口", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/save-order-info")
	@ApiOperation(value = "订单信息回传的接口")
	public AjaxResult saveOrderInfo(BLBAPIDTO dto) throws BLBSyncDataException {
		return comInsService.saveOrderInfo(dto);
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "百联保调用的接口", title = "订单在保人员回传的接口", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/save-offline-order-person")
	@ApiOperation(value = "订单在保人员回传的接口")
	public AjaxResult saveOfflineOrderPerson(BLBAPIDTO dto) throws BLBSyncDataException {
		return comInsService.saveOfflineOrderPerson(dto);
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "百联保调用的接口", title = "电子保单地址回传的接口", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/save-policy-url")
	@ApiOperation(value = "电子保单地址回传的接口")
	public AjaxResult savePolicyUrl(BLBAPIDTO dto) throws BLBSyncDataException {
		return comInsService.savePolicyUrl(dto);
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "百联保调用的接口", title = "根据百联保订单id删除saas保单信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/delete-policy")
	@ApiOperation(value = "根据百联保订单id删除saas保单信息")
	public AjaxResult deletePolicy(BLBAPIDTO dto) throws BLBSyncDataException {
		return comInsService.deletePolicy(dto);
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "百联保调用的接口", title = "保全信息回传接口", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/save-preservation-info")
	@ApiOperation(value = "保全信息回传接口")
	public AjaxResult savePerservationInfo(BLBAPIDTO dto) throws BLBSyncDataException {
		return comInsService.savePerservationInfo(dto);
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "百联保调用的接口", title = "被标记为线下百联保购买的保单保全信息回传接口", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/save-offline-preservation-info")
	@ApiOperation(value = "被标记为线下百联保购买的保单保全信息回传接口")
	public AjaxResult saveOfflinePerservationInfo(BLBAPIDTO dto) throws BLBSyncDataException {
		return comInsService.saveOfflinePerservationInfo(dto);
	}

	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "百联保调用的接口", title = "保全缴费待支付消息处理接口", systemType = Log.SYSTEMTYPE_BACKMANAGE)
	@PostMapping("/send-ins-unpaid-msg")
	@ApiOperation(value = "保全缴费待支付消息处理接口")
	public AjaxResult sendInsUnpaidMsg(BLBAPIDTO dto) throws BLBSyncDataException {
		return comInsService.sendInsUnpaidMsg(dto);
	}
}
