package com.bcxin.platform.web.controller.grant;

import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.grant.ComBhAccount;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.grant.ComBhAccountDTO;
import com.bcxin.platform.service.grant.ComBhAccountService;
import com.bcxin.platform.util.log.Log;
import com.bcxin.platform.web.controller.base.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 企业渤海账户的controller层
 * by llc 2020-08-11
 */
@RestController
@RequestMapping("/com/bh/account")
@Api(tags = { "" }, description = "企业渤海账户")
public class ComBhAccountController extends BaseController {


	@Autowired
	private ComBhAccountService comBhAccountService;


	/**
	 * 获取企业渤海账户
	 * @param comBhAccount
	 * @author llc
	 * @date 2020-08-11
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业渤海账户", title = "获取企业渤海账户", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "获取企业渤海账户", httpMethod = "POST", notes = "获取企业渤海账户", response = Result.class)
	@PostMapping(value = "get-com-bh-account")
	public Result getComBhAccount(ComBhAccount comBhAccount) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhAccountService.getComBhAccount(comBhAccount).setBack(getRequest());
	}




	/**
	 * 获取渤海账户余额
	 * @param dto
	 * @author llc
	 * @date 2020-08-20
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业渤海账户", title = "获取渤海账户余额", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "获取渤海账户余额", httpMethod = "POST", notes = "获取渤海账户余额", response = Result.class)
	@PostMapping(value = "get-com-bh-account-amount")
	public Result getComBhAccountAmount(ComBhAccountDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhAccountService.getComBhAccountAmount(dto).setBack(getRequest());
	}


	/**
	 * 企业开户发送验证码
	 * @param dto
	 * @author llc
	 * @date 2020-08-25
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业渤海账户", title = "企业开户发送验证码", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "企业开户发送验证码", httpMethod = "POST", notes = "企业开户发送验证码", response = Result.class)
	@PostMapping(value = "send-open-account-verify-code")
	public Result sendOpenAccountVerifyCode(ComBhAccountDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhAccountService.sendOpenAccountVerifyCode(dto).setBack(getRequest());
	}


	/**
	 * 注册企业渤海账户
	 * @param dto
	 * @author llc
	 * @date 2020-08-11
	 */
	@Log(operation = Log.OPERA_TYPE_SAVE, modle = "企业渤海账户", title = "注册企业渤海账户", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "注册企业渤海账户", httpMethod = "POST", notes = "注册企业渤海账户", response = Result.class)
	@PostMapping(value = "save-com-bh-account")
	public Result saveComBhAccount(ComBhAccountDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhAccountService.saveComBhAccount(dto).setBack(getRequest());
	}


	/**
	 * 修改企业渤海账户
	 * @param dto
	 * @author llc
	 * @date 2020-08-11
	 */
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "企业渤海账户", title = "修改企业渤海账户", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "修改企业渤海账户", httpMethod = "POST", notes = "修改企业渤海账户", response = Result.class)
	@PostMapping(value = "update-com-bh-account")
	public Result updateComBhAccount(ComBhAccountDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhAccountService.updateComBhAccount(dto).setBack(getRequest());
	}


	/**
	 * 查询渤海银行列表
	 * @param comBhAccount
	 * @author llc
	 * @date 2020-08-11
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业渤海账户", title = "查询渤海银行列表", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "查询渤海银行列表", httpMethod = "POST", notes = "查询渤海银行列表", response = Result.class)
	@PostMapping(value = "get-bh-bank-list")
	public Result getBhBankList(ComBhAccount comBhAccount) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhAccountService.getBhBankList(comBhAccount).setBack(getRequest());
	}

	/**
	 * 企业业务发送验证码
	 * @param dto
	 * @author llc
	 * @date 2020-08-11
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业渤海账户", title = "发送验证码", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "发送验证码", httpMethod = "POST", notes = "发送验证码", response = Result.class)
	@PostMapping(value = "send-verify-code")
	public Result sendVerifyCode(ComBhAccountDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhAccountService.sendVerifyCode(dto).setBack(getRequest());
	}


	/**
	 * 渤海银账户充值
	 * @param dto
	 * @author llc
	 * @date 2020-08-11
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业渤海账户", title = "渤海银账户充值", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "渤海银账户充值", httpMethod = "POST", notes = "渤海银账户充值", response = Result.class)
	@PostMapping(value = "bh-account-recharge")
	public Result bhAccountRecharge(ComBhAccountDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhAccountService.bhAccountRecharge(dto).setBack(getRequest());
	}


	/**
	 * 渤海银账户提现
	 * @param dto
	 * @author llc
	 * @date 2020-08-11
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业渤海账户", title = "渤海银账户提现", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "渤海银账户提现", httpMethod = "POST", notes = "渤海银账户提现", response = Result.class)
	@PostMapping(value = "bh-account-withdrawa")
	public Result bhAccountWithdrawa(ComBhAccountDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhAccountService.bhAccountWithdrawa(dto).setBack(getRequest());
	}


	/**
	 * 获取账户历史明细列表
	 * @param dto
	 * @author llc
	 * @date 2020-08-11
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "企业渤海账户", title = "获取账户历史明细列表", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "获取账户历史明细列表", httpMethod = "POST", notes = "获取账户历史明细列表", response = Result.class)
	@PostMapping(value = "get-account-history-detail-list")
	public Result getAccountHistoryDetailList(ComBhAccountDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhAccountService.getAccountHistoryDetailList(dto).setBack(getRequest());
	}


	/**
	 * 修改手机
	 * @param dto
	 * @author llc
	 * @date 2020-10-12
	 */
	@Log(operation = Log.OPERA_TYPE_UPDATE, modle = "企业渤海账户", title = "修改手机", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "修改手机", httpMethod = "POST", notes = "修改手机", response = Result.class)
	@PostMapping(value = "update-mobilephone")
	public Result updateMobilePhone(ComBhAccountDTO dto) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return comBhAccountService.updateMobilePhone(dto).setBack(getRequest());
	}







}
