package com.bcxin.platform.web.controller.company;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.PerBaseInfoDto;
import com.bcxin.platform.dto.company.PerInfoQueryDto;
import com.bcxin.platform.service.company.PerBaseInfoService;
import com.bcxin.platform.util.log.Log;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 人员基础信息Controller
 * 
 * @author task
 * @date 2021-04-09
 */
@RestController
@Api(tags = { "" }, description = "V5-人员信息")
@RequestMapping("/person")
public class PerBaseInfoController extends BaseController{

    @Autowired
    private PerBaseInfoService perBaseInfoService;


    /**
     * 查询人员基础信息列表
     */
    @PostMapping("/list")
    public TableDataInfo list(PerBaseInfo perBaseInfo){
        startPage();
        List<PerBaseInfo> list = perBaseInfoService.selectPerBaseInfoList(perBaseInfo);
        return getDataTable(list);
    }

    /**
     * 新增修改保存人员信息
     */
    @Log(title = "新增修改人员信息", modle = "人员管理", operation = Log.OPERA_TYPE_UPDATE, systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @ApiOperation(value = "新增修改人员信息", httpMethod = "POST", notes = "新增修改人员信息")
    @PostMapping("/edit")
    public AjaxResult editSave(PerBaseInfoDto perBaseInfo){
        return toAjax(perBaseInfoService.updatePerBaseInfo(perBaseInfo));
    }

    /**
     * 新增修改保存人员信息(批量)
     */
    @Log(title = "新增修改保存人员信息(批量)", modle = "人员管理", operation = Log.OPERA_TYPE_UPDATE, systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @ApiOperation(value = "新增修改保存人员信息(批量)", httpMethod = "POST", notes = "新增修改人员信息(批量)")
    @PostMapping("/editBatch")
    public AjaxResult editBatch(String perBaseInfoDtos){
        List<PerBaseInfoDto> list = JSONArray.parseArray(perBaseInfoDtos,PerBaseInfoDto.class);
        return toAjax(perBaseInfoService.editBatch(list));
    }

    /**
     * 删除人员基础信息
     */
    @Log(title = "删除人员信息", modle = "人员管理", operation = Log.OPERA_TYPE_UPDATE, systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @ApiOperation(value = "删除人员信息", httpMethod = "POST", notes = "删除人员信息")
    @PostMapping( "/remove")
    public AjaxResult remove(String ids){
        return toAjax(perBaseInfoService.deletePerBaseInfoByIds(ids));
    }


    /**
     * 通过人员ID列表查询人员基础信息
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-04-15
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "用户管理", title = "通过人员ID列表查询人员基础信息", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "/get-per-base-info-list-by-perids")
    @ApiOperation(value = "通过人员ID列表查询人员基础信息", httpMethod = "POST", notes = "通过人员ID列表查询人员基础信息", response = PerBaseInfoDto.class)
    public Result getPerBaseInfoListByPerIds(PerBaseInfoDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        return perBaseInfoService.getPerBaseInfoListByPerIds(dto).setBack(getRequest());
    }


    /**
     * 华为云会议人员信息查询
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-12-11
     */
    @Log(operation = Log.OPERA_TYPE_SELECT, modle = "用户管理", title = "华为云会议人员信息查询", systemType = Log.SYSTEMTYPE_BACKMANAGE)
    @PostMapping(value = "/page-for-huawei-meet-per-info")
    @ApiOperation(value = "华为云会议人员信息查询", httpMethod = "POST", notes = "华为云会议人员信息查询", response = PerBaseInfoDto.class)
    public Result pageForuaweiMeetPerInfo(PerInfoQueryDto dto) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        if (currentUser.getPerId() == null) {
            return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
        }
        return perBaseInfoService.pageForhuaweiMeetPerInfo(dto).setBack(getRequest());
    }

}
