package com.bcxin.platform.web.controller.attend;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.utils.poi.ExcelUtil;
import com.bcxin.platform.common.utils.validator.ValidatorUtils;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.bcxin.platform.domain.attend.AttendPer;
import com.bcxin.platform.dto.attend.AttendPerDto;
import com.bcxin.platform.service.attend.AttendPerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 考勤人员Controller
 * 
 * @author lin
 * @date 2021-08-10
 */
@RestController
@RequestMapping("/attend/per")
public class AttendPerController extends BaseController{


    @Autowired
    private AttendPerService attendPerService;


    /**
     * 分页查询考勤人员列表
     */
    @PostMapping("/searchForPage")
    public TableDataInfo searchForPage(AttendPerDto attendPer){
        startPage();
        List<AttendPerDto> list = attendPerService.selectList(attendPer);
        return getDataTable(list);
    }

    /**
     * 导出考勤人员列表
     */
    @Log(title = "考勤人员", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public AjaxResult export(AttendPerDto attendPer){
        List<AttendPerDto> list = attendPerService.selectList(attendPer);
        ExcelUtil<AttendPerDto> util = new ExcelUtil<AttendPerDto>(AttendPerDto.class);
        return util.exportExcel(list, "attendPer");
    }

    /**
     * 根据id查询考勤人员
     */
    @GetMapping("/findById/{id}")
    public AjaxResult findById(@PathVariable("id") Long id){
        AttendPer attendPer = attendPerService.findById(id);
        return AjaxResult.success(null,attendPer);
    }

    /**
     * 添加考勤人员
     */
    @Log(title = "添加考勤人员", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    public AjaxResult editSave(AttendPer attendPer) throws CloneNotSupportedException {
        ValidatorUtils.validateEntity(attendPer, AddGroup.class);
        return toAjax(attendPerService.save(attendPer));
    }

    /**
     * 变更考勤套
     */
    @Log(title = "变更考勤套", businessType = BusinessType.UPDATE)
    @PostMapping("/update")
    public AjaxResult update(AttendPer attendPer){
        ValidatorUtils.validateEntity(attendPer, UpdateGroup.class);
        return toAjax(attendPerService.update(attendPer));
    }

    /**
     * 删除考勤人员
     */
    @Log(title = "考勤人员", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    public AjaxResult remove(String ids){
        return toAjax(attendPerService.deleteByIds(ids));
    }


    @PostMapping(value = "getDepartPersonList")
    public AjaxResult getDepartPersonList(AttendPerDto searchDto) {
        return AjaxResult.success(null,attendPerService.getDepartPersonList(searchDto));
    }
}
