package com.bcxin.platform.web.controller.app.attend;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.domain.attend.Attend;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.dto.app.AppAttendPerDto;
import com.bcxin.platform.dto.attend.AttendDto;
import com.bcxin.platform.dto.attend.AttendPerDto;
import com.bcxin.platform.service.attend.AttendPerService;
import com.bcxin.platform.service.attend.AttendService;
import com.bcxin.platform.service.company.PerBaseInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 考勤套Controller
 * 
 * @author lin
 * @date 2021-08-10
 */
@RestController
@RequestMapping("/app/attend/per")
public class AppAttendPerController extends BaseController{

    @Autowired
    private AttendPerService attendPerService;

    @Autowired
    private AttendService attendService;

    @Autowired
    private PerBaseInfoService perBaseInfoService;

    /**
     * 换班 人员列表
     */
    @PostMapping("/list")
    public TableDataInfo list(AppAttendPerDto perDto){
        List<AppAttendPerDto> list = attendPerService.selectListForPer(perDto);
        return getDataTable(list);
    }

    /**
     * 是否负责人
     */
    @GetMapping("/isCharge")
    public AjaxResult isCharge(AttendDto attend){
        List<Attend> list = attendService.selectListForPer(attend);
        return AjaxResult.success(null,list.size()>0 ? 1:0);
    }

    /**
     * 排班人员选择
     * @param searchDto
     * @return
     */
    @PostMapping(value = "getPerList")
    public AjaxResult getPerList(@RequestBody AttendPerDto searchDto) {
        return AjaxResult.success(null,perBaseInfoService.selectPerBaseInfoByPerIds(searchDto));
    }
    /**
     * 排班人员选择
     * @param searchDto
     * @return
     */
    @PostMapping(value = "getDepartPersonList")
    public AjaxResult getDepartPersonList(AttendPerDto searchDto) {
        return AjaxResult.success(null,attendPerService.getDepartPersonList(searchDto));
    }

    /**
     * 未排班人员列表
     * @param searchDto
     * @return
     */
    @PostMapping(value = "getUnSchedulPersonList")
    public AjaxResult getUnSchedulPersonList(AppAttendPerDto searchDto) {
        return AjaxResult.success(null,attendPerService.getUnSchedulPersonList(searchDto));
    }

    /**
     * 删除考勤人员
     */
    @Log(title = "考勤人员", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    public AjaxResult remove(@RequestBody AppAttendPerDto attendPerDto){
        return toAjax(attendPerService.deleteByPerIds(attendPerDto));
    }
}
