package com.bcxin.platform.web.controller.app.attend;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.validator.ValidatorUtils;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.bcxin.platform.domain.attend.AttendChangeShift;
import com.bcxin.platform.service.attend.AttendChangeShiftService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 换班记录Controller
 * 
 * @author lin
 * @date 2021-09-20
 */
@RestController
@RequestMapping("app/attend/changeShift")
public class AppAttendChangeShiftController extends BaseController{

    @Autowired
    private AttendChangeShiftService attendChangeShiftService;

    /**
     * 保存换班记录
     */
    @Log(title = "换班记录", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    public AjaxResult editSave(AttendChangeShift attendChangeShift){
        ValidatorUtils.validateEntity(attendChangeShift, UpdateGroup.class);
        if(attendChangeShift.getPerId().longValue() == attendChangeShift.getChangePerId().longValue()){
            return AjaxResult.error("换班申请人与换班人不能是同一个人");
        }
        if(DateUtils.parseDate(attendChangeShift.getChangeDate()).getTime() < DateUtils.getNowDate().getTime()){
            return AjaxResult.error("当天之后的日期才能换班");
        }
        return toAjax(attendChangeShiftService.update(attendChangeShift));
    }

}
