package com.bcxin.platform.web.config;

import com.bcxin.platform.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;

import java.util.HashMap;
import java.util.Map;

/**
 * @author linqinglin
 * @date 2021/01/30 0030 16:17
 */
@Component
public class ViewResolverConfig implements WebMvcConfigurer {

    @Autowired
    @Qualifier("thymeleafViewResolver")
    private ThymeleafViewResolver thymeleafViewResolver;

    @Override
    public void configureViewResolvers(ViewResolverRegistry registry) {
        if (thymeleafViewResolver != null) {
            Map<String, Object> map = new HashMap<>();
            /**
             * 每次在发布新版本的时候，如果修改了js文件或者css文件就会需要清理浏览器的缓存，
             * 如果让用户清理缓存，无异于是一件很麻烦的事。
             * 所以我们只需要控制版本号，就可以实现这个功能。
             *
             * <link th:href="@{/css/style.css(v=${js_version})}" rel="stylesheet"/>
             * <script th:src="@{/js/planUtil.js(v=${js_version})}"></script>
             */
            map.put("js_version", DateUtils.dateTimeNow());
            thymeleafViewResolver.setStaticVariables(map);
        }
    }
}
