/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.system.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.PlatFormBusinessException;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.system.SysPost;
import com.bcxin.platform.mapper.system.SysPostMapper;
import com.bcxin.platform.mapper.system.SysUserPostMapper;
import com.bcxin.platform.service.system.ISysPostService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class SysPostServiceImpl
implements ISysPostService {
    @Autowired
    private SysPostMapper postMapper;
    @Autowired
    private SysUserPostMapper userPostMapper;

    @Override
    public List<SysPost> selectPostList(SysPost post) {
        return this.postMapper.selectPostList(post);
    }

    @Override
    public List<SysPost> selectPostAll() {
        return this.postMapper.selectPostAll();
    }

    @Override
    public List<SysPost> selectPostsByUserId(Long userId) {
        List<SysPost> userPosts = this.postMapper.selectPostsByUserId(userId);
        List<SysPost> posts = this.postMapper.selectPostAll();
        block0: for (SysPost post : posts) {
            for (SysPost userRole : userPosts) {
                if (post.getPostId().longValue() != userRole.getPostId().longValue()) continue;
                post.setFlag(true);
                continue block0;
            }
        }
        return posts;
    }

    @Override
    public SysPost selectPostById(Long postId) {
        return this.postMapper.selectPostById(postId);
    }

    @Override
    public int deletePostByIds(String ids) throws PlatFormBusinessException {
        Long[] postIds;
        for (Long postId : postIds = Convert.toLongArray((String)ids)) {
            SysPost post = this.selectPostById(postId);
            if (this.countUserPostById(postId) <= 0) continue;
            throw new PlatFormBusinessException(String.format("%1$s\u5df2\u5206\u914d,\u4e0d\u80fd\u5220\u9664", post.getPostName()));
        }
        return this.postMapper.deletePostByIds(postIds);
    }

    @Override
    public int insertPost(SysPost post) {
        return this.postMapper.insertPost(post);
    }

    @Override
    public int updatePost(SysPost post) {
        return this.postMapper.updatePost(post);
    }

    @Override
    public int countUserPostById(Long postId) {
        return this.userPostMapper.countUserPostById(postId);
    }

    @Override
    public String checkPostNameUnique(SysPost post) {
        Long postId = StringUtils.isNull((Object)post.getPostId()) ? -1L : post.getPostId();
        SysPost info = this.postMapper.checkPostNameUnique(post.getPostName());
        if (StringUtils.isNotNull((Object)((Object)info)) && info.getPostId().longValue() != postId.longValue()) {
            return "1";
        }
        return "0";
    }

    @Override
    public String checkPostCodeUnique(SysPost post) {
        Long postId = StringUtils.isNull((Object)post.getPostId()) ? -1L : post.getPostId();
        SysPost info = this.postMapper.checkPostCodeUnique(post.getPostCode());
        if (StringUtils.isNotNull((Object)((Object)info)) && info.getPostId().longValue() != postId.longValue()) {
            return "1";
        }
        return "0";
    }
}

