/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.company.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.PerOrgRelation;
import com.bcxin.platform.dto.company.ComDepartDto;
import com.bcxin.platform.mapper.company.PerOrgRelationMapper;
import com.bcxin.platform.service.company.PerOrgRelationService;
import com.bcxin.platform.util.PageInfoUtils;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PerOrgRelationServiceImpl
implements PerOrgRelationService {
    @Resource
    private PerOrgRelationMapper perOrgRelationMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public PerOrgRelation selectPerOrgRelationById(Long perOrgRelationId) {
        return this.perOrgRelationMapper.selectPerOrgRelationById(perOrgRelationId);
    }

    @Override
    public List<PerOrgRelation> selectPerOrgRelationList(PerOrgRelation perOrgRelation) {
        return this.perOrgRelationMapper.selectPerOrgRelationList(perOrgRelation);
    }

    @Override
    public int insertPerOrgRelation(PerOrgRelation perOrgRelation) {
        perOrgRelation.setPerOrgRelationId(this.idWorker.nextId());
        perOrgRelation.setCreateTime(DateUtils.getNowDate());
        return this.perOrgRelationMapper.insertPerOrgRelation(perOrgRelation);
    }

    @Override
    public int updatePerOrgRelation(PerOrgRelation perOrgRelation) {
        perOrgRelation.setUpdateTime(DateUtils.getNowDate());
        return this.perOrgRelationMapper.updatePerOrgRelation(perOrgRelation);
    }

    @Override
    public int deletePerOrgRelationByIds(String ids) {
        return this.perOrgRelationMapper.deletePerOrgRelationByIds(Convert.toStrArray((String)ids));
    }

    @Override
    public int deletePerOrgRelationById(Long perOrgRelationId) {
        return this.perOrgRelationMapper.deletePerOrgRelationById(perOrgRelationId);
    }

    @Override
    public Result getTaskDepartPerSonList(ComDepartDto comDepart) {
        if (comDepart.getComId() == null) {
            return Result.fail((String)"\u8bf7\u4f20\u4f01\u4e1aID");
        }
        if (comDepart.getPageNumber() == null) {
            return Result.fail((String)"\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (comDepart.getPageSize() == null) {
            return Result.fail((String)"\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (comDepart.getDepartId() == null) {
            return Result.fail((String)"\u90e8\u95e8ID\u4e3a\u7a7a");
        }
        PerOrgRelation perOrgRelation = new PerOrgRelation();
        if (comDepart.getDepartId() != null) {
            if (comDepart.getDepartId() == -1L) {
                perOrgRelation.setOrgId(comDepart.getComId());
            } else {
                perOrgRelation.setOrgId(comDepart.getDepartId());
            }
        }
        perOrgRelation.setComId(comDepart.getComId());
        PageHelper.startPage((int)comDepart.getPageNumber(), (int)comDepart.getPageSize());
        List<Map<String, Object>> perList = this.perOrgRelationMapper.getTaskDepartPerSonList(perOrgRelation);
        return Result.success((String)"", new PageInfoUtils<Map<String, Object>>(perList));
    }

    @Override
    public Result getDepartPerSonList(ComDepartDto comDepart) {
        if (comDepart.getComId() == null) {
            return Result.fail((String)"\u8bf7\u4f20\u4f01\u4e1aID");
        }
        if (comDepart.getPageNumber() == null) {
            return Result.fail((String)"\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (comDepart.getPageSize() == null) {
            return Result.fail((String)"\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (comDepart.getDepartId() == null) {
            return Result.fail((String)"\u90e8\u95e8ID\u4e3a\u7a7a");
        }
        PerOrgRelation perOrgRelation = new PerOrgRelation();
        if (comDepart.getDepartId() != null) {
            if (comDepart.getDepartId() == -1L) {
                perOrgRelation.setOrgId(comDepart.getComId());
            } else {
                perOrgRelation.setOrgId(comDepart.getDepartId());
            }
        }
        perOrgRelation.setComId(comDepart.getComId());
        PageHelper.startPage((int)comDepart.getPageNumber(), (int)comDepart.getPageSize());
        List<Map<String, Object>> perList = this.perOrgRelationMapper.getDepartPerSonList(perOrgRelation);
        return Result.success((String)"", new PageInfoUtils<Map<String, Object>>(perList));
    }

    @Override
    public PerOrgRelation selectPerOrgRelationByTlkId(String tlkRelationId) {
        return this.perOrgRelationMapper.selectPerOrgRelationByTlkId(tlkRelationId);
    }

    @Override
    public void saveBatch(List<PerOrgRelation> relationList) {
        this.perOrgRelationMapper.saveBatch(relationList);
    }

    @Override
    public Result getCommonPerListByKeyword(ComDepartDto comDepartDto) {
        if (comDepartDto.getPageNumber() == null) {
            return Result.fail((String)"\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (comDepartDto.getPageSize() == null) {
            return Result.fail((String)"\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((String)comDepartDto.getKeyword())) {
            return Result.fail((String)"\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)comDepartDto.getPageNumber(), (int)comDepartDto.getPageSize());
        List<Map<String, String>> perList = this.perOrgRelationMapper.getCommonPerListByKeyword(comDepartDto.getComId(), comDepartDto.getKeyword());
        return Result.success((String)"", new PageInfoUtils<Map<String, String>>(perList));
    }

    @Override
    public Result getHuaweiDepartPerSonList(ComDepartDto comDepart) {
        if (comDepart.getComId() == null) {
            return Result.fail((String)"\u8bf7\u4f20\u4f01\u4e1aID");
        }
        if (comDepart.getPageNumber() == null) {
            return Result.fail((String)"\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (comDepart.getPageSize() == null) {
            return Result.fail((String)"\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (comDepart.getDepartId() == null) {
            return Result.fail((String)"\u90e8\u95e8ID\u4e3a\u7a7a");
        }
        PerOrgRelation perOrgRelation = new PerOrgRelation();
        if (comDepart.getDepartId() != null) {
            if (comDepart.getDepartId() == -1L) {
                perOrgRelation.setOrgId(comDepart.getComId());
            } else {
                perOrgRelation.setOrgId(comDepart.getDepartId());
            }
        }
        perOrgRelation.setComId(comDepart.getComId());
        PageHelper.startPage((int)comDepart.getPageNumber(), (int)comDepart.getPageSize());
        List<Map<String, Object>> perList = this.perOrgRelationMapper.getHuaweiDepartPerSonList(perOrgRelation);
        return Result.success((String)"", new PageInfoUtils<Map<String, Object>>(perList));
    }

    @Override
    public PerOrgRelation findByPerId(Long perId) {
        return this.perOrgRelationMapper.findByPerId(perId);
    }
}

