/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.meeting;

import com.alibaba.fastjson.JSON;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.company.ComBaseInfo;
import com.bcxin.platform.domain.meeting.ComHuaweiMeetMatch;
import com.bcxin.platform.domain.product.PoliceHuaweiMeetMatch;
import com.bcxin.platform.domain.system.SysPolice;
import com.bcxin.platform.dto.meeting.AddCorpDTO;
import com.bcxin.platform.dto.meeting.AdminDTO;
import com.bcxin.platform.dto.meeting.ComHuaweiMeetMatchDto;
import com.bcxin.platform.dto.meeting.CorpBasicDTO;
import com.bcxin.platform.dto.meeting.MeetingExtInfoDTO;
import com.bcxin.platform.dto.meeting.MeetingOrderRequestDTO;
import com.bcxin.platform.mapper.company.ComBaseInfoMapper;
import com.bcxin.platform.mapper.meeting.ComHuaweiMeetMatchMapper;
import com.bcxin.platform.mapper.meeting.PoliceHuaweiMeetMatchMapper;
import com.bcxin.platform.mapper.order.SysPoliceMapper;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.meeting.HuaweiMeetMatchService;
import com.bcxin.platform.util.http.MD5Util;
import com.bcxin.platform.util.huawei.HttpBuildUtil;
import com.bcxin.platform.util.huawei.HttpUtil;
import com.bcxin.platform.util.huawei.RestRequest;
import com.bcxin.platform.util.huawei.RestResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class HuaweiMeetMatchServiceImpl
implements HuaweiMeetMatchService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ComHuaweiMeetMatchMapper comHuaweiMeetMatchMapper;
    @Resource
    private PoliceHuaweiMeetMatchMapper policeHuaweiMeetMatchMapper;
    @Resource
    private SysPoliceMapper sysPoliceMapper;
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;
    @Resource
    private CommonService commonService;

    @Override
    public List<Map> getComHuaweiMeet(ComHuaweiMeetMatchDto comHuaweiMeetMatch) throws Exception {
        return this.comHuaweiMeetMatchMapper.findMapListByName(comHuaweiMeetMatch);
    }

    @Override
    public Result delComHuaweiMeet(ComHuaweiMeetMatch comHuaweiMeetMatch) throws V5BusinessException {
        Result result = this.delHuaweiManage(comHuaweiMeetMatch.getHuaweiComId());
        if ("0".equals(result.getRetType())) {
            this.comHuaweiMeetMatchMapper.delete((long)comHuaweiMeetMatch.getComId());
        }
        return result;
    }

    @Override
    public Result delPoliceHuaweiMeet(PoliceHuaweiMeetMatch policeHuaweiMeetMatch) throws V5BusinessException {
        Result result = this.delHuaweiManage(policeHuaweiMeetMatch.getHuaweiComId());
        if ("0".equals(result.getRetType())) {
            this.policeHuaweiMeetMatchMapper.delete((long)policeHuaweiMeetMatch.getPoliceId());
        }
        return result;
    }

    @Override
    public Result saveComHuaweiMeet(ComHuaweiMeetMatch comHuaweiMeetMatch) throws V5BusinessException {
        ComBaseInfo comBaseInfo = this.comBaseInfoMapper.selectComBaseInfoById(comHuaweiMeetMatch.getComId());
        if (comBaseInfo == null) {
            return Result.fail((String)"comId\u65e0\u6548");
        }
        if (this.comHuaweiMeetMatchMapper.selectCount((long)comHuaweiMeetMatch.getComId()) > 0) {
            return Result.fail((String)"\u534e\u4e3a\u4e91\u4f01\u4e1a\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        String comCerNo = comBaseInfo.getComCerNo();
        String account = "HW_" + comCerNo;
        String pwd = MD5Util.string2MD5("Saas@" + comCerNo.substring(comCerNo.length() - 6, comCerNo.length())).substring(4, 16);
        Result result = this.buildCompanyByAdmin(comBaseInfo.getComName(), account, pwd);
        if ("0".equals(result.getRetType())) {
            String Id = String.valueOf(result.getData());
            comHuaweiMeetMatch.setHuaweiManageUserName(account);
            comHuaweiMeetMatch.setHuaweiComId(Long.parseLong(Id));
            comHuaweiMeetMatch.setHuaweiManagePassWord(pwd);
            this.comHuaweiMeetMatchMapper.insert(comHuaweiMeetMatch);
            return Result.success((String)"");
        }
        return result;
    }

    @Override
    public Result savePoliceHuaweiMeet(PoliceHuaweiMeetMatch policeHuaweiMeetMatch) throws V5BusinessException {
        SysPolice sysPolice = (SysPolice)this.sysPoliceMapper.getByPrimaryKey(policeHuaweiMeetMatch.getPoliceId());
        if (sysPolice == null) {
            return Result.fail((String)"policeId\u65e0\u6548");
        }
        if (this.policeHuaweiMeetMatchMapper.selectCount((long)policeHuaweiMeetMatch.getPoliceId()) > 0) {
            return Result.fail((String)"\u534e\u4e3a\u4e91\u516c\u5b89\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        String policeCerNo = UUID.randomUUID().toString().replaceAll("-", "");
        String account = "HW_" + policeCerNo.substring(3, 18);
        String pwd = MD5Util.string2MD5("Saas@" + policeCerNo.substring(3, 18)).substring(4, 16);
        Result result = this.buildCompanyByAdmin(sysPolice.getPoliceName(), account, pwd);
        if ("0".equals(result.getRetType())) {
            String Id = String.valueOf(result.getData());
            policeHuaweiMeetMatch.setHuaweiManageUserName(account);
            policeHuaweiMeetMatch.setHuaweiComId(Long.parseLong(Id));
            policeHuaweiMeetMatch.setHuaweiManagePassWord(pwd);
            this.policeHuaweiMeetMatchMapper.insert(policeHuaweiMeetMatch);
            return Result.success((String)"");
        }
        return result;
    }

    @Override
    public List<Map> findComHuaweiMeetMatchList() {
        return this.comHuaweiMeetMatchMapper.findComHuaweiMeetMatchList();
    }

    @Override
    public Result refreshComHuaweiMeet(ComHuaweiMeetMatch comHuaweiMeetMatch) throws Exception {
        Long comId = comHuaweiMeetMatch.getComId();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("key", "huaweiMeetCom" + comId);
        String result = cn.hutool.http.HttpUtil.get((String)(this.commonService.getSystemConfig("SYS_PIC_HTTP_ADDR") + "/public/common/delete-redis-by-key"), paramMap);
        if (StringUtils.isEmpty((CharSequence)result) || !result.contains("msg")) {
            throw new Exception("\u8c03\u7528saas\u63a5\u53e3\u8fd4\u56de\u51fa\u9519");
        }
        HashMap resultMap = (HashMap)new ObjectMapper().readValue(result, HashMap.class);
        if (StringUtils.isNotBlank((CharSequence)resultMap.get("msg").toString())) {
            throw new Exception("\u8c03\u7528saas\u63a5\u53e3\u8fd4\u56de\u51fa\u9519");
        }
        return Result.success((String)"");
    }

    @Override
    public Result purchasingResource(MeetingOrderRequestDTO dto) throws V5BusinessException {
        String accessToken = this.commonService.getHuaweiMeetIAMTokens(28814466L);
        MeetingExtInfoDTO meiDTO = new MeetingExtInfoDTO();
        meiDTO.setCustomer_id(this.commonService.getSystemConfig("MEET_LOGIN_USER_ID"));
        dto.setExtend_info(meiDTO);
        String url = "https://api.meeting.huaweicloud.com/v2/mbc/reasource";
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Auth-Token", accessToken);
        String param = JSON.toJSONString((Object)dto);
        this.logger.info(" ========== \u4f1a\u8bae\u8d44\u6e90\u8ba2\u8d2d\u63a5\u53e3");
        this.logger.info(" ========== \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        this.logger.info(" ========== \u8bf7\u6c42\u62a5\u6587\uff1a" + param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        this.logger.info(" ========== \u8fd4\u56de\u62a5\u6587\uff1a" + response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((CharSequence)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        Map<String, Object> map = HttpBuildUtil.getMapData(response);
        if (map == null) {
            return Result.fail((String)"\u672a\u83b7\u53d6\u5230\u8ba2\u5355\u7f16\u7801!");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)map.get("order_id"));
    }

    @Override
    public Result orderPayByOrderNo(String orderNo) throws V5BusinessException {
        String accessToken = this.commonService.getHuaweiMeetIAMTokens(28814466L);
        String url = "https://bss.myhuaweicloud.com" + "/v1.0/{domain_id}/customer/order-mgr/order/pay".replace("{domain_id}", this.commonService.getSystemConfig("MEET_LOGIN_USER_ID"));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("orderId", orderNo);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Auth-Token", accessToken);
        String param = JSON.toJSONString(data);
        this.logger.info(" ========== \u652f\u4ed8\u5305\u5468\u671f\u4ea7\u54c1\u8ba2\u5355\u63a5\u53e3");
        this.logger.info(" ========== \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        this.logger.info(" ========== \u8bf7\u6c42\u62a5\u6587\uff1a" + param);
        RestResponse response = HttpUtil.post(url, param, accessToken);
        this.logger.info(" ========== \u8fd4\u56de\u62a5\u6587\uff1a" + response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg2(response);
        if (StringUtils.isNotEmpty((CharSequence)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        Map<String, Object> map = HttpBuildUtil.getMapData(response);
        if (map == null) {
            return Result.fail((String)"\u672a\u83b7\u53d6\u5230\u8ba2\u5355\u7f16\u7801!");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)map.get("tradeNo"));
    }

    @Override
    public Result searchResourcesByComId(Long huaweiComId) throws V5BusinessException {
        String accessToken = this.commonService.getComManageHuaweiMeetAccessToken(this.commonService.getSystemConfig("MEET_MANAGE_SP_USER"), this.commonService.getSystemConfig("MEET_MANAGE_SP_PWD"), "28814466");
        String url = "https://api.meeting.huaweicloud.com" + "/v1/usg/dcs/sp/corp/{corpId}/resource".replace("{corpId}", String.valueOf(huaweiComId));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("offset", "0");
        map.put("limit", "100");
        map.put("status", "0");
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        this.logger.info(" ========== \u4f1a\u8bae\u8d44\u6e90\u8ba2\u8d2d\u63a5\u53e3");
        this.logger.info(" ========== \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, map);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        this.logger.info(" ========== \u8fd4\u56de\u62a5\u6587\uff1a" + response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((CharSequence)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)response.getEntity());
    }

    @Override
    public Result buildCompanyByAdmin(String companyName, String account, String pwd) throws V5BusinessException {
        AddCorpDTO acDTO = new AddCorpDTO();
        AdminDTO adminInfo = new AdminDTO();
        adminInfo.setAccount(account);
        adminInfo.setPwd(pwd);
        adminInfo.setName(companyName);
        adminInfo.setEmail(this.commonService.getSystemConfig("MEET_BUILD_SP_EMAIL"));
        acDTO.setAdminInfo(adminInfo);
        CorpBasicDTO basicInfo = new CorpBasicDTO();
        basicInfo.setName(companyName);
        acDTO.setBasicInfo(basicInfo);
        String accessToken = this.commonService.getComManageHuaweiMeetAccessToken(this.commonService.getSystemConfig("MEET_MANAGE_SP_USER"), this.commonService.getSystemConfig("MEET_MANAGE_SP_PWD"), "28814466");
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/sp/corp";
        String param = JSON.toJSONString((Object)acDTO);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        this.logger.info(" ========== \u7ba1\u7406\u5458\u521b\u5efa\u4f01\u4e1a\u63a5\u53e3");
        this.logger.info(" ========== \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        this.logger.info(" ========== \u8bf7\u6c42\u62a5\u6587\uff1a" + param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        this.logger.info(" ========== \u8fd4\u56de\u62a5\u6587\uff1a" + response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((CharSequence)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        Map<String, Object> map = HttpBuildUtil.getMapData(response);
        if (map == null) {
            return Result.fail((String)"\u672a\u83b7\u53d6\u5230\u4f01\u4e1aID!");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)map.get("value"));
    }

    @Override
    public Result delHuaweiManage(Long huaweiComId) throws V5BusinessException {
        String accessToken = this.commonService.getComManageHuaweiMeetAccessToken(this.commonService.getSystemConfig("MEET_MANAGE_SP_USER"), this.commonService.getSystemConfig("MEET_MANAGE_SP_PWD"), "28814466");
        String url = "https://api.meeting.huaweicloud.com" + "/v1/usg/dcs/sp/corp/{corpId}".replace("{corpId}", String.valueOf(huaweiComId));
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        this.logger.info(" ========== \u7ba1\u7406\u5220\u9664\u4f01\u4e1a\u63a5\u53e3");
        this.logger.info(" ========== \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("DELETE", headMap, null, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        this.logger.info(" ========== \u8fd4\u56de\u62a5\u6587\uff1a" + response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((CharSequence)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result addResourcesByHuaweiComId(List<Map<String, String>> list, Long huaweiComId) throws V5BusinessException {
        String accessToken = this.commonService.getComManageHuaweiMeetAccessToken(this.commonService.getSystemConfig("MEET_MANAGE_SP_USER"), this.commonService.getSystemConfig("MEET_MANAGE_SP_PWD"), "28814466");
        String url = "https://api.meeting.huaweicloud.com" + "/v1/usg/dcs/sp/corp/{corpId}/resource".replace("{corpId}", String.valueOf(huaweiComId));
        String param = JSON.toJSONString(list);
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        this.logger.info(" ========== \u5206\u914d\u4f01\u4e1a\u8d44\u6e90\u63a5\u53e3");
        this.logger.info(" ========== \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        this.logger.info(" ========== \u8bf7\u6c42\u62a5\u6587\uff1a" + param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        this.logger.info(" ========== \u8fd4\u56de\u62a5\u6587\uff1a" + response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((CharSequence)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result delResource(String[] ids, Long huaweiComId) throws V5BusinessException {
        String accessToken = this.commonService.getComManageHuaweiMeetAccessToken(this.commonService.getSystemConfig("MEET_MANAGE_SP_USER"), this.commonService.getSystemConfig("MEET_MANAGE_SP_PWD"), "28814466");
        String url = "https://api.meeting.huaweicloud.com" + "/v1/usg/dcs/sp/corp/{corpId}/resource/delete".replace("{corpId}", String.valueOf(huaweiComId));
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        String param = JSON.toJSONString((Object)ids);
        this.logger.info(" ========== \u7ba1\u7406\u5220\u9664\u4f01\u4e1a\u63a5\u53e3");
        this.logger.info(" ========== \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        this.logger.info(" ========== \u8bf7\u6c42\u62a5\u6587\uff1a" + param);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, param, null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        this.logger.info(" ========== \u8fd4\u56de\u62a5\u6587\uff1a" + response.getEntity());
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((CharSequence)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public List<Map> queryPoliceRegoinCombobox() {
        return this.sysPoliceMapper.queryPoliceRegoinCombobox();
    }

    @Override
    public List<Map> queryPoliceByProvinceIdCombobox(String provinceId) {
        return this.sysPoliceMapper.queryPoliceByProvinceIdCombobox(provinceId);
    }
}

