/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.framework.shiro.service;

import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.system.SysUserOnline;
import com.bcxin.platform.framework.shiro.session.OnlineSession;
import com.bcxin.platform.service.system.ISysUserOnlineService;
import java.io.Serializable;
import org.apache.shiro.session.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysShiroService {
    @Autowired
    private ISysUserOnlineService onlineService;

    public void deleteSession(OnlineSession onlineSession) {
        this.onlineService.deleteOnlineById(String.valueOf(onlineSession.getId()));
    }

    public Session getSession(Serializable sessionId) {
        SysUserOnline userOnline = this.onlineService.selectOnlineById(String.valueOf(sessionId));
        return StringUtils.isNull((Object)userOnline) ? null : this.createSession(userOnline);
    }

    public Session createSession(SysUserOnline userOnline) {
        OnlineSession onlineSession = new OnlineSession();
        if (StringUtils.isNotNull((Object)userOnline)) {
            onlineSession.setId((Serializable)((Object)userOnline.getSessionId()));
            onlineSession.setHost(userOnline.getIpaddr());
            onlineSession.setBrowser(userOnline.getBrowser());
            onlineSession.setOs(userOnline.getOs());
            onlineSession.setDeptName(userOnline.getDeptName());
            onlineSession.setLoginName(userOnline.getLoginName());
            onlineSession.setStartTimestamp(userOnline.getStartTimestamp());
            onlineSession.setLastAccessTime(userOnline.getLastAccessTime());
            onlineSession.setTimeout(userOnline.getExpireTime());
        }
        return onlineSession;
    }
}

