/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.framework.web.service;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="permission")
public class PermissionService {
    private static final Logger log = LoggerFactory.getLogger(PermissionService.class);
    public static final String NOACCESS = "hidden";
    private static final String ROLE_DELIMETER = ",";
    private static final String PERMISSION_DELIMETER = ",";

    public String hasPermi(String permission) {
        return this.isPermitted(permission) ? "" : NOACCESS;
    }

    public String lacksPermi(String permission) {
        return this.isLacksPermitted(permission) ? "" : NOACCESS;
    }

    public String hasAnyPermi(String permissions) {
        return this.hasAnyPermissions(permissions, ",") ? "" : NOACCESS;
    }

    public String hasRole(String role) {
        return this.isRole(role) ? "" : NOACCESS;
    }

    public String lacksRole(String role) {
        return this.isLacksRole(role) ? "" : NOACCESS;
    }

    public String hasAnyRoles(String roles) {
        return this.isAnyRoles(roles, ",") ? "" : NOACCESS;
    }

    public boolean isUser() {
        Subject subject = SecurityUtils.getSubject();
        return subject != null && subject.getPrincipal() != null;
    }

    public boolean isPermitted(String permission) {
        return SecurityUtils.getSubject().isPermitted(permission);
    }

    public boolean isLacksPermitted(String permission) {
        return !this.isPermitted(permission);
    }

    public boolean hasAnyPermissions(String permissions) {
        return this.hasAnyPermissions(permissions, ",");
    }

    public boolean hasAnyPermissions(String permissions, String delimeter) {
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            if (delimeter == null || delimeter.length() == 0) {
                delimeter = ",";
            }
            for (String permission : permissions.split(delimeter)) {
                if (permission == null || !subject.isPermitted(permission.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRole(String role) {
        return SecurityUtils.getSubject().hasRole(role);
    }

    public boolean isLacksRole(String role) {
        return !this.isRole(role);
    }

    public boolean isAnyRoles(String roles) {
        return this.isAnyRoles(roles, ",");
    }

    public boolean isAnyRoles(String roles, String delimeter) {
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            if (delimeter == null || delimeter.length() == 0) {
                delimeter = ",";
            }
            for (String role : roles.split(delimeter)) {
                if (!subject.hasRole(role.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public Object getPrincipalProperty(String property) {
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            Object principal = subject.getPrincipal();
            try {
                BeanInfo bi = Introspector.getBeanInfo(principal.getClass());
                for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                    if (!pd.getName().equals(property)) continue;
                    return pd.getReadMethod().invoke(principal, (Object[])null);
                }
            }
            catch (Exception e) {
                log.error("Error reading property [{}] from principal of type [{}]", (Object)property, (Object)principal.getClass().getName());
            }
        }
        return null;
    }
}

