/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.util.v5;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcxinHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(BcxinHttpUtil.class);

    public static String sendPostRequest(String url, List<NameValuePair> params) {
        log.debug("--------\u5f00\u59cb\u53d1\u9001http\u8bf7\u6c42--------");
        log.debug("\u8bf7\u6c42\u5730\u5740:[{}]\uff1a", (Object)url);
        BcxinHttpUtil.logParams(params);
        Stopwatch stopwatch = Stopwatch.createStarted();
        String result = "";
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(1000).setConnectTimeout(1000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
            try (CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = resp.getEntity();
                result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                long nanos = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                log.debug("\u8fd4\u56de\u7ed3\u679c\uff1a[{}]", (Object)result);
                log.debug("\u5171\u8017\u65f6[{}]\u6beb\u79d2\uff1a", (Object)nanos);
                log.debug("--------\u7ed3\u675fhttp\u8bf7\u6c42--------");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static String sendPostRequest(String url, Map<String, String> bdpConfigMap, Object obj) {
        log.debug("--------\u5f00\u59cb\u53d1\u9001http\u8bf7\u6c42--------");
        log.debug("\u8bf7\u6c42\u5730\u5740:[{}]\uff1a", (Object)url);
        log.debug("--------\u5f00\u59cb\u53d1\u9001http\u8bf7\u6c42--------");
        log.debug("\u8bf7\u6c42\u5730\u5740:[{}]\uff1a", (Object)url);
        Stopwatch stopwatch = Stopwatch.createStarted();
        String result = "";
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String authString = String.format("%s:%s", bdpConfigMap.get("clientId"), bdpConfigMap.get("secret"));
            String authStringEnc = Base64.getEncoder().encodeToString(authString.getBytes(StandardCharsets.UTF_8));
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(1000).setSocketTimeout(1000).setConnectTimeout(1000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setHeader("Authorization", String.format("Basic %s", authStringEnc));
            httpPost.setHeader("Content-Type", "application/json");
            JSONObject body = new JSONObject();
            body.put("routeKey", (Object)"");
            body.put("messageType", (Object)1);
            body.put("protocol", (Object)0);
            body.put("topicProducerId", (Object)bdpConfigMap.get("id"));
            body.put("data", obj);
            StringEntity stringEntity = new StringEntity(JSONObject.toJSONString((Object)body, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), "UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
            try (CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = resp.getEntity();
                result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                long nanos = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                log.debug("\u8fd4\u56de\u7ed3\u679c\uff1a[{}]", (Object)result);
                log.debug("\u5171\u8017\u65f6[{}]\u6beb\u79d2\uff1a", (Object)nanos);
                log.debug("--------\u7ed3\u675fhttp\u8bf7\u6c42--------");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static String sendTianLingPostRequest(String url, Map<String, String> params) {
        log.debug("--------\u5f00\u59cb\u53d1\u9001http\u8bf7\u6c42--------");
        log.debug("\u8bf7\u6c42\u5730\u5740:[{}]\uff1a", (Object)url);
        ArrayList pairList = Lists.newArrayList();
        if (MapUtil.isNotEmpty(params)) {
            for (Map.Entry<String, String> elem : params.entrySet()) {
                pairList.add(new BasicNameValuePair(elem.getKey(), elem.getValue()));
            }
        }
        return BcxinHttpUtil.sendPostRequest(url, pairList);
    }

    public static String sendPostRequestObj(String url, Map<String, Object> params) {
        log.debug("--------\u5f00\u59cb\u53d1\u9001http\u8bf7\u6c42--------");
        log.debug("\u8bf7\u6c42\u5730\u5740:[{}]\uff1a", (Object)url);
        ArrayList pairList = Lists.newArrayList();
        if (MapUtil.isNotEmpty(params)) {
            for (Map.Entry<String, Object> elem : params.entrySet()) {
                pairList.add(new BasicNameValuePair(elem.getKey(), elem.getValue() == null ? "" : elem.getValue().toString()));
            }
        }
        return BcxinHttpUtil.sendPostRequest(url, pairList);
    }

    public static Map<String, String> getAllRequestParam(HttpServletRequest request) {
        HashMap<String, String> res = new HashMap<String, String>();
        Enumeration temp = request.getParameterNames();
        if (null != temp) {
            while (temp.hasMoreElements()) {
                String en = (String)temp.nextElement();
                String value = request.getParameter(en);
                res.put(en, value);
                if (null != res.get(en) && !"".equals(res.get(en))) continue;
                res.remove(en);
            }
        }
        return res;
    }

    private static void logParams(List<NameValuePair> params) {
        for (NameValuePair pair : params) {
            log.debug("\u8bf7\u6c42\u7684\u53c2\u6570\u540d\uff1a[{}]\uff0c\u503c\uff1a[{}]", (Object)pair.getName(), (Object)pair.getValue());
        }
    }
}

