/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.util.huawei;

import com.alibaba.fastjson.JSON;
import com.bcxin.platform.util.huawei.CheckPathUtil;
import com.bcxin.platform.util.huawei.ErrorEnum;
import com.bcxin.platform.util.huawei.HttpUtil;
import com.bcxin.platform.util.huawei.RestRequest;
import com.bcxin.platform.util.huawei.RestResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBuildUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpBuildUtil.class);
    private static String url = "https://api.meeting.huaweicloud.com";
    private static String schema = CheckPathUtil.getSchemeFromHttpAddress(url);
    private static String ip = CheckPathUtil.getIpFromHttpAddress(url);
    private static int port = CheckPathUtil.getPortFromHttpAddress(url);

    public static HttpHost getHttpHost() {
        HttpHost httpHost = new HttpHost(ip, port, schema);
        return httpHost;
    }

    public static RestRequest buildRestRequest(String method, Map<String, String> headers, String entity, Map<String, String> params) {
        RestRequest restRequest = new RestRequest();
        headers.put("Content-Type", "application/json");
        restRequest.setHttpHeaders(headers);
        restRequest.setHttpMethod(method);
        if (entity != null) {
            restRequest.setEntity(entity);
        }
        if (params != null) {
            restRequest.setParameters(params);
        }
        log.info("restRequest is: " + restRequest.toString());
        return restRequest;
    }

    public static RestResponse sendMsg(String resourceUri, RestRequest restRequest) {
        log.info("enter sendMsg");
        HttpHost host = HttpBuildUtil.getHttpHost();
        RestResponse response = null;
        try {
            response = HttpUtil.getInstance().sendMessage(host, resourceUri, restRequest);
            log.info("response is: " + response.toString());
        }
        catch (URISyntaxException e) {
            log.error("send msg uri syntax error:" + e.getMessage());
        }
        catch (IOException e) {
            log.error("send msg io error:" + e.getMessage());
        }
        log.info("out sendMsg");
        return response;
    }

    public static String failMsg(RestResponse response) {
        String msg = "";
        int httpCode = response.getHttpCode();
        if (httpCode != 200) {
            Map<String, Object> resultMap = HttpBuildUtil.getMapData(response);
            if (resultMap != null && resultMap.get("error_code") != null) {
                String error_code = String.valueOf(resultMap.get("error_code"));
                msg = ErrorEnum.errorMsg(error_code);
            } else {
                msg = "\u670d\u52a1\u7aef\u5f02\u5e38\uff01";
            }
        }
        return msg;
    }

    public static String failMsg2(RestResponse response) {
        String msg = "";
        int httpCode = response.getHttpCode();
        if (httpCode != 200) {
            msg = "\u670d\u52a1\u7aef\u5f02\u5e38\uff01";
        } else {
            Map<String, Object> resultMap = HttpBuildUtil.getMapData(response);
            if (resultMap != null && resultMap.get("error_code") != null) {
                String error_code = String.valueOf(resultMap.get("error_code"));
                msg = ErrorEnum.errorMsg(error_code);
                msg = StringUtils.isEmpty((CharSequence)msg) ? String.valueOf(resultMap.get("error_msg")) : msg;
            }
        }
        return msg;
    }

    public static Map<String, Object> getMapData(RestResponse response) {
        if (response.getEntity() == null) {
            return null;
        }
        return (Map)JSON.parseObject((String)response.getEntity(), Map.class);
    }
}

