/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.wallet.manage;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.wallet.PerWalletAccount;
import com.bcxin.platform.dto.SearchParamDTO;
import com.bcxin.platform.mapper.wallet.manage.PerWalletManageMapper;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.wallet.manage.PerWalletManageService;
import com.bcxin.platform.util.JwtUtil;
import com.bcxin.platform.util.constants.PaymentServiceConst;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PerWalletManageServiceImpl
implements PerWalletManageService {
    private Logger logger = LoggerFactory.getLogger(PerWalletManageServiceImpl.class);
    @Autowired
    private PerWalletManageMapper perWalletMapper;
    @Autowired
    private CommonService commonService;

    @Override
    public List<Map<String, Object>> pagePerInsList(SearchParamDTO dto) throws V5BusinessException {
        return this.perWalletMapper.pagePerWalletList(dto);
    }

    @Override
    public Result getPerWalletAccountByPerId(SearchParamDTO dto) throws V5BusinessException {
        Result r2;
        if (StringUtils.isEmpty((String)dto.getPerId())) {
            throw new V5BusinessException("-1", "\u53c2\u6570perId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, Object> rec = this.perWalletMapper.getPerWalletAccountByPerId(Long.parseLong(dto.getPerId()));
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("perId", dto.getPerId());
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", JwtUtil.createJWT(p));
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        Result r1 = (Result)JSON.parseObject((String)HttpUtil.post((String)(platUrl + "/pay/gongshang/account/query"), requestMap), Result.class);
        System.out.println(JSON.toJSONString((Object)r1));
        if ("0".equals(r1.getRetType())) {
            Map map = (Map)r1.getData();
            rec.put("accountStatus", PaymentServiceConst.getAccountStatus(map.get("account_state").toString()));
            p.put("walletAccountNo", rec.get("walletAccountNo"));
            requestMap.put("token", JwtUtil.createJWT(p));
            r2 = (Result)JSON.parseObject((String)HttpUtil.post((String)(platUrl + "/pay/gongshang/account/balance/query"), requestMap), Result.class);
            System.out.println(JSON.toJSONString((Object)r2));
            if (!"0".equals(r2.getRetType())) {
                return Result.fail((String)r2.getMsg());
            }
        } else {
            return Result.fail((String)r1.getMsg());
        }
        Map map2 = (Map)r2.getData();
        rec.put("totalAmount", map2.get("ledger_bal"));
        rec.put("availableAmount", map2.get("available_bal"));
        rec.put("frozenAmount", map2.get("funds_held"));
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", rec);
    }

    @Override
    public Result updatePerWalletAccount(PerWalletAccount perWalletAccount) throws V5BusinessException {
        if (perWalletAccount.getPerId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570perId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)perWalletAccount.getMobilePhone())) {
            throw new V5BusinessException("-1", "\u53c2\u6570\u7ed1\u5b9a\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int count = this.perWalletMapper.updatePerWalletAccount(perWalletAccount);
        if (count == 0) {
            return Result.fail((String)"\u64cd\u4f5c\u5931\u8d25:");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public List<Map<String, Object>> getPerWalletAccountTradeDetail(SearchParamDTO dto, Integer page, Integer rows) throws V5BusinessException {
        if (dto.getPerId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getWalletAccountNo())) {
            throw new V5BusinessException("-1", "\u4f01\u4e1a\u94b1\u5305\u8d26\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (page == null) {
            throw new V5BusinessException("-1", "\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (rows == null) {
            throw new V5BusinessException("-1", "\u6bcf\u9875\u591a\u5c11\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getStartTime())) {
            throw new V5BusinessException("-1", "\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getEndTime())) {
            throw new V5BusinessException("-1", "\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("id", dto.getPerId());
        p.put("pageNumber", page.toString());
        p.put("pageSize", rows.toString());
        p.put("walletAccountNo", dto.getWalletAccountNo());
        p.put("startDate", dto.getStartTime());
        p.put("endDate", dto.getEndTime());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/gongshang/account/record/query"), requestMap);
        Result result = (Result)JSON.parseObject((String)resultStr, Result.class);
        if ("0".equals(result.getRetType())) {
            Map map = (Map)result.getData();
            if (Integer.parseInt(map.get("total_size").toString()) == 0) {
                return new ArrayList<Map<String, Object>>();
            }
            ArrayList recordlist = (ArrayList)JSON.parseObject((String)map.get("balance_records").toString(), (TypeReference)new TypeReference<ArrayList<Map>>(){}, (Feature[])new Feature[0]);
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            if (recordlist.size() > 0) {
                for (Map record : recordlist) {
                    String perName;
                    HashMap<String, String> m = new HashMap<String, String>();
                    m.put("trade_date", record.get("trade_date").toString().substring(0, record.get("trade_date").toString().length() - 2));
                    m.put("trade_flow_no", (String)record.get("trade_flow_no"));
                    m.put("flow_no", (String)record.get("flow_no"));
                    m.put("accounts_deal_type", PaymentServiceConst.getAccountDealType(record.get("accounts_deal_type").toString()));
                    m.put("accounts_deal_date", record.get("accounts_deal_date").toString().substring(0, record.get("accounts_deal_date").toString().length() - 2));
                    m.put("amount", (String)record.get("amount"));
                    m.put("balance", (String)record.get("balance"));
                    m.put("direction", PaymentServiceConst.getDirection(record.get("direction").toString()));
                    m.put("hand_status", PaymentServiceConst.getHandStatus(record.get("hand_status").toString()));
                    m.put("create_date", record.get("create_date").toString().substring(0, record.get("create_date").toString().length() - 2));
                    m.put("serviceType", PaymentServiceConst.getServiceType(record.get("service_code").toString()));
                    m.put("trade_type", PaymentServiceConst.getTradeType(record.get("trade_type").toString()));
                    m.put("account_in", StringUtils.isEmpty((String)record.get("account_in").toString()) ? "-" : record.get("account_in"));
                    m.put("account_out", StringUtils.isEmpty((String)record.get("account_out").toString()) ? "-" : record.get("account_out"));
                    m.put("wallet_account_no", dto.getWalletAccountNo());
                    m.put("perId", dto.getPerId());
                    if (StringUtils.isEmpty((String)record.get("account_in").toString())) {
                        m.put("account_in_name", "-");
                    } else {
                        perName = this.perWalletMapper.getPerNameByWalletNo(record.get("account_in").toString());
                        m.put("account_in_name", StringUtils.isEmpty((String)perName) ? "-" : perName);
                    }
                    if (StringUtils.isEmpty((String)record.get("account_out").toString())) {
                        m.put("account_out_name", "-");
                    } else {
                        perName = this.perWalletMapper.getPerNameByWalletNo(record.get("account_out").toString());
                        m.put("account_out_name", StringUtils.isEmpty((String)perName) ? "-" : perName);
                    }
                    m.put("memo", StringUtils.isEmpty((String)record.get("memo").toString()) ? "-" : record.get("memo"));
                    list.add(m);
                }
            }
            return list;
        }
        this.logger.error(result.getMsg());
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    public Result getPerAccountTradeVoucher(SearchParamDTO dto) throws V5BusinessException {
        if (dto.getTradeFlowNo() == null) {
            throw new V5BusinessException("-1", "\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("perId", dto.getPerId());
        p.put("bizOrderNo", dto.getTradeFlowNo());
        p.put("walletAccountNo", dto.getWalletAccountNo());
        System.out.println(((Object)p).toString());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        return (Result)JSON.parseObject((String)HttpUtil.post((String)(platUrl + "/pay/gongshang/account/trade/voucher"), requestMap), Result.class);
    }

    @Override
    public Result getPerAccountPayVoucher(SearchParamDTO dto) throws V5BusinessException {
        if (dto.getTradeFlowNo() == null) {
            throw new V5BusinessException("-1", "\u4ea4\u6613\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Object, Object> p = new HashMap<Object, Object>();
        p.put("bizOrderNo", dto.getTradeFlowNo());
        System.out.println(((Object)p).toString());
        String token = JwtUtil.createJWT(p);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        requestMap.put("token", token);
        String platUrl = this.commonService.getSystemConfig("PAYMENT_PLATFORM_URL");
        String resultStr = HttpUtil.post((String)(platUrl + "/pay/fbank/account/pay/voucher"), requestMap);
        return (Result)JSON.parseObject((String)resultStr, Result.class);
    }
}

