/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.wallet;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.dto.order.ComOrderPayDTO;
import com.bcxin.platform.dto.wallet.ComWalletAccountDTO;
import com.bcxin.platform.dto.wallet.ComWalletTransferDTO;
import com.bcxin.platform.mapper.wallet.ComWalletAccountMapper;
import com.bcxin.platform.service.cache.TaskCacheService;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.oauth.RedisUtil;
import com.bcxin.platform.service.wallet.ComWalletPaymentService;
import com.bcxin.platform.service.wallet.ComWalletService;
import com.github.pagehelper.util.StringUtil;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class ComWalletPaymentServiceImpl
implements ComWalletPaymentService {
    @Resource
    private ComWalletAccountMapper comWalletAccountMapper;
    @Resource
    private TaskCacheService taskCacheService;
    @Resource
    private CommonService commonService;
    @Resource
    private ComWalletService comWalletService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private RedisUtil redisUtil;

    @Override
    @Transactional(value="transactionManager")
    public Result payValidate(ComOrderPayDTO dto) throws V5BusinessException {
        if (dto.getActualPayAmount() == null) {
            return Result.fail((String)"\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getInComId() == null) {
            return Result.fail((String)"\u5165\u8d26\u65b9Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getComId() == null) {
            return Result.fail((String)"\u51fa\u8d26\u65b9Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComWalletAccountDTO inComAccount = this.comWalletAccountMapper.getComWalletAccountByComId(dto.getInComId());
        ComWalletAccountDTO outComAccount = this.comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());
        if (inComAccount == null) {
            return Result.fail((String)"\u5165\u8d26\u65b9\u672a\u5f00\u901a\u4f01\u4e1a\u94b1\u5305\uff0c\u65e0\u6cd5\u6536\u6b3e\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5f00\u901a\uff01");
        }
        if (StringUtil.isEmpty((String)inComAccount.getWalletAccountNo())) {
            return Result.fail((String)"\u5165\u8d26\u65b9\u672a\u5f00\u901a\u4f01\u4e1a\u94b1\u5305\uff0c\u65e0\u6cd5\u6536\u6b3e\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u5f00\u901a\uff01");
        }
        if (outComAccount == null) {
            return Result.fail((String)"\u60a8\u7684\u516c\u53f8\u672a\u5f00\u901a\u4f01\u4e1a\u94b1\u5305\uff0c\u8bf7\u5148\u5f00\u901a\uff01");
        }
        if (StringUtil.isEmpty((String)outComAccount.getWalletAccountNo())) {
            return Result.fail((String)"\u60a8\u7684\u516c\u53f8\u672a\u5f00\u901a\u4f01\u4e1a\u94b1\u5305\uff0c\u8bf7\u5148\u5f00\u901a\uff01");
        }
        String envi = this.commonService.getSystemConfig("PLATFORM_SIGN");
        if (Objects.equals(envi, "PASP-NC")) {
            return Result.success((String)"");
        }
        Result balanceResult = this.comWalletService.getComWalletAccountAmount(outComAccount);
        if (balanceResult.getData() != null) {
            Map map = (Map)balanceResult.getData();
            if (map.get("availableAmount") == null || StringUtil.isEmpty((String)map.get("availableAmount").toString())) {
                return Result.fail((String)"\u83b7\u53d6\u516c\u53f8\u8d26\u6237\u4f59\u989d\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\uff01");
            }
            if (new BigDecimal(map.get("availableAmount").toString().replace(",", "")).compareTo(dto.getActualPayAmount().setScale(2, 5)) < 0) {
                return Result.fail((String)"\u60a8\u516c\u53f8\u94b1\u5305\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u5148\u5145\u503c\uff01");
            }
        }
        return Result.success((String)"");
    }

    @Override
    public Result getPayPhone(ComOrderPayDTO dto) throws V5BusinessException {
        ComWalletAccountDTO outComAccount = this.comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());
        return Result.success((String)"", (Object)outComAccount.getMobilePhone());
    }

    @Override
    public Result sendPayVerifyCode(ComOrderPayDTO dto) throws V5BusinessException {
        ComWalletAccountDTO outComAccount = this.comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());
        String verifyCode = this.commonService.sendCode(outComAccount.getMobilePhone());
        this.stringRedisTemplate.opsForValue().set((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":PAY:" + dto.getComOrderId() + outComAccount.getMobilePhone()), (Object)verifyCode, 180000L, TimeUnit.MILLISECONDS);
        this.stringRedisTemplate.opsForValue().set((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":PAY:" + dto.getComOrderId() + dto.getComId()), (Object)UUID.randomUUID().toString(), 1800L, TimeUnit.SECONDS);
        return new Result();
    }

    @Override
    @Transactional(value="transactionManager")
    public Result actualPay(ComOrderPayDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            Result result = new Result();
            result.setRetType("-1");
            result.setMsg("\u64cd\u4f5c\u5931\u8d25:comId\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return result;
        }
        ComWalletAccountDTO outComAccount = this.comWalletAccountMapper.getComWalletAccountByComId(dto.getComId());
        String cacheVerifyCode = (String)this.stringRedisTemplate.opsForValue().get((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":PAY:" + dto.getComOrderId() + outComAccount.getMobilePhone()));
        if (StringUtil.isEmpty((String)cacheVerifyCode)) {
            Result result = new Result();
            result.setRetType("-1");
            result.setMsg("\u64cd\u4f5c\u5931\u8d25:\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u3002");
            return result;
        }
        if (!cacheVerifyCode.equals(dto.getActiveCode())) {
            Result result = new Result();
            result.setRetType("-1");
            result.setMsg("\u64cd\u4f5c\u5931\u8d25:\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002");
            return result;
        }
        String token = (String)this.stringRedisTemplate.opsForValue().get((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":PAY:" + dto.getComOrderId() + dto.getComId()));
        if (StringUtil.isEmpty((String)token)) {
            Result result = new Result();
            result.setRetType("-1");
            result.setMsg("\u64cd\u4f5c\u5931\u8d25:\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u8ba2\u5355\u6216\u8ba2\u5355\u652f\u4ed8\u6709\u6548\u65f6\u95f4\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u9a8c\u8bc1\u7801\u8fdb\u884c\u652f\u4ed8\u3002");
            return result;
        }
        String envi = this.commonService.getSystemConfig("PLATFORM_SIGN");
        if (Objects.equals(envi, "PASP-NC")) {
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
        }
        if (BigDecimal.ZERO.compareTo(dto.getActualPayAmount()) == 0) {
            return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
        }
        ComWalletTransferDTO transferDTO = new ComWalletTransferDTO();
        transferDTO.setOutId(dto.getComId().toString());
        transferDTO.setInId(dto.getInComId().toString());
        transferDTO.setAmount(dto.getActualPayAmount().setScale(2, 5).toString());
        transferDTO.setComment(dto.getComment());
        transferDTO.setNeedActiveCode("0");
        Result result = this.comWalletService.comWalletAccountTransfer(transferDTO);
        if ("-1".equals(result.getRetType())) {
            return result;
        }
        this.stringRedisTemplate.delete((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":PAY:" + dto.getComOrderId() + outComAccount.getMobilePhone()));
        this.stringRedisTemplate.delete((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":PAY:" + dto.getComOrderId() + dto.getComId()));
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

