/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.system.impl;

import com.bcxin.platform.common.annotation.DataScope;
import com.bcxin.platform.common.core.domain.entity.SysRole;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.PlatFormBusinessException;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.common.utils.spring.SpringUtils;
import com.bcxin.platform.domain.system.SysRoleDept;
import com.bcxin.platform.domain.system.SysRoleMenu;
import com.bcxin.platform.domain.system.SysUserRole;
import com.bcxin.platform.mapper.system.SysRoleDeptMapper;
import com.bcxin.platform.mapper.system.SysRoleMapper;
import com.bcxin.platform.mapper.system.SysRoleMenuMapper;
import com.bcxin.platform.mapper.system.SysUserRoleMapper;
import com.bcxin.platform.service.system.ISysRoleService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class SysRoleServiceImpl
implements ISysRoleService {
    @Autowired
    private SysRoleMapper roleMapper;
    @Autowired
    private SysRoleMenuMapper roleMenuMapper;
    @Autowired
    private SysUserRoleMapper userRoleMapper;
    @Autowired
    private SysRoleDeptMapper roleDeptMapper;

    @Override
    @DataScope(deptAlias="d")
    public List<SysRole> selectRoleList(SysRole role) {
        return this.roleMapper.selectRoleList(role);
    }

    @Override
    public Set<String> selectRoleKeys(Long userId) {
        List<SysRole> perms = this.roleMapper.selectRolesByUserId(userId);
        HashSet<String> permsSet = new HashSet<String>();
        for (SysRole perm : perms) {
            if (!StringUtils.isNotNull((Object)perm)) continue;
            permsSet.addAll(Arrays.asList(perm.getRoleKey().trim().split(",")));
        }
        return permsSet;
    }

    @Override
    public List<SysRole> selectRolesByUserId(Long userId) {
        List<SysRole> userRoles = this.roleMapper.selectRolesByUserId(userId);
        List<SysRole> roles = this.selectRoleAll();
        block0: for (SysRole role : roles) {
            for (SysRole userRole : userRoles) {
                if (role.getRoleId().longValue() != userRole.getRoleId().longValue()) continue;
                role.setFlag(true);
                continue block0;
            }
        }
        return roles;
    }

    @Override
    public List<SysRole> selectRoleAll() {
        return ((SysRoleServiceImpl)SpringUtils.getAopProxy((Object)this)).selectRoleList(new SysRole());
    }

    @Override
    public SysRole selectRoleById(Long roleId) {
        return this.roleMapper.selectRoleById(roleId);
    }

    @Override
    @Transactional(value="transactionManager")
    public boolean deleteRoleById(Long roleId) {
        this.roleMenuMapper.deleteRoleMenuByRoleId(roleId);
        this.roleDeptMapper.deleteRoleDeptByRoleId(roleId);
        return this.roleMapper.deleteRoleById(roleId) > 0;
    }

    @Override
    @Transactional(value="transactionManager")
    public int deleteRoleByIds(String ids) {
        Long[] roleIds;
        for (Long roleId : roleIds = Convert.toLongArray((String)ids)) {
            this.checkRoleAllowed(new SysRole(roleId));
            SysRole role = this.selectRoleById(roleId);
            if (this.countUserRoleByRoleId(roleId) <= 0) continue;
            throw new PlatFormBusinessException(String.format("%1$s\u5df2\u5206\u914d,\u4e0d\u80fd\u5220\u9664", role.getRoleName()));
        }
        this.roleMenuMapper.deleteRoleMenu(roleIds);
        this.roleDeptMapper.deleteRoleDept(roleIds);
        return this.roleMapper.deleteRoleByIds(roleIds);
    }

    @Override
    @Transactional(value="transactionManager")
    public int insertRole(SysRole role) {
        this.roleMapper.insertRole(role);
        return this.insertRoleMenu(role);
    }

    @Override
    @Transactional(value="transactionManager")
    public int updateRole(SysRole role) {
        this.roleMapper.updateRole(role);
        this.roleMenuMapper.deleteRoleMenuByRoleId(role.getRoleId());
        return this.insertRoleMenu(role);
    }

    @Override
    @Transactional(value="transactionManager")
    public int authDataScope(SysRole role) {
        this.roleMapper.updateRole(role);
        this.roleDeptMapper.deleteRoleDeptByRoleId(role.getRoleId());
        return this.insertRoleDept(role);
    }

    public int insertRoleMenu(SysRole role) {
        int rows = 1;
        ArrayList<SysRoleMenu> list = new ArrayList<SysRoleMenu>();
        for (Long menuId : role.getMenuIds()) {
            SysRoleMenu rm = new SysRoleMenu();
            rm.setRoleId(role.getRoleId());
            rm.setMenuId(menuId);
            list.add(rm);
        }
        if (list.size() > 0) {
            rows = this.roleMenuMapper.batchRoleMenu(list);
        }
        return rows;
    }

    public int insertRoleDept(SysRole role) {
        int rows = 1;
        ArrayList<SysRoleDept> list = new ArrayList<SysRoleDept>();
        for (Long deptId : role.getDeptIds()) {
            SysRoleDept rd = new SysRoleDept();
            rd.setRoleId(role.getRoleId());
            rd.setDeptId(deptId);
            list.add(rd);
        }
        if (list.size() > 0) {
            rows = this.roleDeptMapper.batchRoleDept(list);
        }
        return rows;
    }

    @Override
    public String checkRoleNameUnique(SysRole role) {
        Long roleId = StringUtils.isNull((Object)role.getRoleId()) ? -1L : role.getRoleId();
        SysRole info = this.roleMapper.checkRoleNameUnique(role.getRoleName());
        if (StringUtils.isNotNull((Object)info) && info.getRoleId().longValue() != roleId.longValue()) {
            return "1";
        }
        return "0";
    }

    @Override
    public String checkRoleKeyUnique(SysRole role) {
        Long roleId = StringUtils.isNull((Object)role.getRoleId()) ? -1L : role.getRoleId();
        SysRole info = this.roleMapper.checkRoleKeyUnique(role.getRoleKey());
        if (StringUtils.isNotNull((Object)info) && info.getRoleId().longValue() != roleId.longValue()) {
            return "1";
        }
        return "0";
    }

    @Override
    public void checkRoleAllowed(SysRole role) {
        if (StringUtils.isNotNull((Object)role.getRoleId()) && role.isAdmin()) {
            throw new PlatFormBusinessException("\u4e0d\u5141\u8bb8\u64cd\u4f5c\u8d85\u7ea7\u7ba1\u7406\u5458\u89d2\u8272");
        }
    }

    @Override
    public int countUserRoleByRoleId(Long roleId) {
        return this.userRoleMapper.countUserRoleByRoleId(roleId);
    }

    @Override
    public int changeStatus(SysRole role) {
        return this.roleMapper.updateRole(role);
    }

    @Override
    public int deleteAuthUser(SysUserRole userRole) {
        return this.userRoleMapper.deleteUserRoleInfo(userRole);
    }

    @Override
    public int deleteAuthUsers(Long roleId, String userIds) {
        return this.userRoleMapper.deleteUserRoleInfos(roleId, Convert.toLongArray((String)userIds));
    }

    @Override
    public int insertAuthUsers(Long roleId, String userIds) {
        Long[] users = Convert.toLongArray((String)userIds);
        ArrayList<SysUserRole> list = new ArrayList<SysUserRole>();
        for (Long userId : users) {
            SysUserRole ur = new SysUserRole();
            ur.setUserId(userId);
            ur.setRoleId(roleId);
            list.add(ur);
        }
        return this.userRoleMapper.batchUserRole(list);
    }
}

