/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.common;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.StrSpliter;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.platform.common.core.domain.entity.SysDictData;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.BusinessLog;
import com.bcxin.platform.domain.company.ConfigIndustryDict;
import com.bcxin.platform.domain.log.SysSmsLog;
import com.bcxin.platform.domain.system.SysRegion;
import com.bcxin.platform.dto.ConfigDictDto;
import com.bcxin.platform.dto.grant.ConfigBankOutletsDTO;
import com.bcxin.platform.mapper.common.ConfigDictMapper;
import com.bcxin.platform.mapper.common.ConfigIndustryDictMapper;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.mapper.grant.ConfigBankOutletsMapper;
import com.bcxin.platform.mapper.log.SysSmsLogMapper;
import com.bcxin.platform.mapper.system.SysConfigMapper;
import com.bcxin.platform.mapper.system.SysRegionMapper;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.oauth.RedisUtil;
import com.bcxin.platform.service.system.ISysConfigService;
import com.bcxin.platform.service.system.ISysDictTypeService;
import com.bcxin.platform.util.HttpUtils;
import com.bcxin.platform.util.http.HuaWeiSmsContent;
import com.bcxin.platform.util.http.SMSUtil;
import com.bcxin.platform.util.huawei.HttpBuildUtil;
import com.bcxin.platform.util.huawei.HttpUtil;
import com.bcxin.platform.util.huawei.RestRequest;
import com.bcxin.platform.util.huawei.RestResponse;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class CommonServiceImpl
implements CommonService {
    private static Logger logger = LoggerFactory.getLogger(CommonServiceImpl.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private CommonService commonService;
    @Autowired
    private SysRegionMapper sysRegionMapper;
    @Resource
    private ISysConfigService sysConfigService;
    @Autowired
    private SysConfigMapper configMapper;
    @Resource
    private ConfigDictMapper configDictMapper;
    @Resource
    private ConfigIndustryDictMapper configIndustryDictMapper;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private ISysDictTypeService sysDictTypeService;
    private static final Integer PHONE_LENGTH = 11;
    @Resource
    private SysSmsLogMapper sysSmsLogMapper;
    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;
    @Resource
    private ConfigBankOutletsMapper configBankOutletsMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public String getSystemConfig(String key) {
        return this.sysConfigService.selectConfigByKey(key);
    }

    @Override
    public void setConditions(String key, String value) {
        key = "ARS-PASP:Conditions:" + key;
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value, 345600000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getConditions(String key) {
        String result = (String)this.stringRedisTemplate.opsForValue().get((Object)("ARS-PASP:Conditions:" + key));
        return result;
    }

    @Override
    public void sendMessageToApp(String tilte, String content, String messageType, String ids, Long comId, Long id) {
        new Thread(() -> {
            try {
                HashMap params = CollUtil.newHashMap();
                params.put("title", tilte);
                params.put("content", content);
                params.put("messageType", messageType);
                params.put("comId", comId);
                params.put("comTaskId", id);
                params.put("objectId", id);
                params.put("ids", ids);
                params.put("platId", "10");
                params.put("way", "3");
                String result = cn.hutool.http.HttpUtil.post((String)(this.getSystemConfig("SYS_PIC_HTTP_ADDR") + "/public/message/send-message"), (Map)params);
                System.out.println(result);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }).start();
    }

    @Override
    public void BunissLogDemo(BusinessLog businessLog) throws V5BusinessException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("businessType", businessLog.getBusinessType());
        paramMap.put("currentApprovalLevel", businessLog.getCurrentApprovalLevel());
        paramMap.put("partyType", businessLog.getPartyType());
        paramMap.put("partyId", businessLog.getPartyId());
        paramMap.put("comId", businessLog.getComId());
        paramMap.put("businessHandlStatus", businessLog.getBusinessHandlStatus());
        paramMap.put("handlePerId", businessLog.getHandlePerId());
        try {
            String result = cn.hutool.http.HttpUtil.post((String)this.commonService.getSystemConfig("YWRZ_URL"), paramMap);
            JSONObject jsonBack = JSONUtil.parseObj((String)result);
            String retType = jsonBack.get((Object)"retType").toString();
            if (!"0".equals(retType)) {
                throw new V5BusinessException("-2", "\u65b0\u589e\u4e1a\u52a1\u65e5\u5fd7\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new V5BusinessException(e.toString(), "\u65b0\u589e\u4e1a\u52a1\u65e5\u5fd7\u5931\u8d25");
        }
    }

    @Override
    public Result getRegionById(SysRegion sysRegion) {
        SysRegion rec = this.sysRegionMapper.selectSysRegionById(sysRegion.getRegionId());
        return Result.success((String)"", (Object)((Object)rec));
    }

    @Override
    public Result getRegionByParentId(SysRegion sysRegion) {
        List<SysRegion> list = this.sysRegionMapper.selectByParentId(sysRegion.getParentRegionId());
        return Result.success((String)"", list);
    }

    @Override
    public Result getRegionByLevel(SysRegion sysRegion) {
        List<SysRegion> list = this.sysRegionMapper.selectByLevel(Integer.valueOf(sysRegion.getRegionLevel()));
        return Result.success((String)"", list);
    }

    @Override
    public Result getRegionAsObj() {
        List list;
        String redisKey = this.redisUtil.REDIS_PREFIX_KEY + ":RegionConfig";
        HashMap m = Maps.newHashMap();
        if (!this.stringRedisTemplate.hasKey((Object)redisKey).booleanValue()) {
            list = this.sysRegionMapper.selectAll();
            this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)JSON.toJSONString((Object)list), 604800L, TimeUnit.SECONDS);
        } else {
            list = JSON.parseArray((String)((String)this.stringRedisTemplate.opsForValue().get((Object)redisKey)), SysRegion.class);
        }
        for (SysRegion rec : list) {
            m.put(String.valueOf(rec.getRegionId()), rec);
        }
        return Result.success((String)"", (Object)m);
    }

    @Override
    public Result getRegions() {
        ArrayList<SysRegion> r = new ArrayList<SysRegion>();
        List<SysRegion> l = this.sysRegionMapper.selectByLevel(1);
        List<SysRegion> list = this.sysRegionMapper.selectAll();
        for (SysRegion s : l) {
            r.add(this.getChild(s, list));
        }
        return Result.success((String)"", r);
    }

    private SysRegion getChild(SysRegion root, List<SysRegion> list) {
        ArrayList<SysRegion> l = new ArrayList<SysRegion>();
        for (SysRegion sr : list) {
            if (!String.valueOf(sr.getParentRegionId()).equals(String.valueOf(root.getRegionId()))) continue;
            SysRegion sr2 = this.getChild(sr, list);
            l.add(sr2);
        }
        root.setS(l);
        return root;
    }

    @Override
    public Result getRegionList(String sysRegionList) {
        ArrayList<SysRegion> list = new ArrayList<SysRegion>();
        if (StringUtils.isNotEmpty((String)sysRegionList)) {
            for (String regionid : sysRegionList.split(",")) {
                if (!StringUtils.isNumeric((CharSequence)regionid)) {
                    return Result.fail((String)"\u5730\u5740\u5f02\u5e38", (Object)regionid);
                }
                SysRegion rec = this.sysRegionMapper.selectSysRegionById(Long.valueOf(regionid));
                if (rec == null) {
                    return Result.fail((String)"\u5730\u5740\u4e0d\u5b58\u5728", (Object)regionid);
                }
                list.add(rec);
            }
        }
        return Result.success((String)"", list);
    }

    @Override
    public Result getRegionByName(String regionName) {
        return Result.success((String)"", (Object)((Object)this.sysRegionMapper.selectByName(regionName)));
    }

    @Override
    public String getConfigBank(String key) {
        Result result = this.getConfigDictById("bankCode");
        Map dictData = (Map)result.getData();
        for (ConfigDictDto sysDictData : (List)dictData.get("bankCode")) {
            if (!sysDictData.getCodeValue().equals(key)) continue;
            return sysDictData.getLabel();
        }
        return null;
    }

    @Override
    public Result getConfigBankList() {
        return Result.success((String)"", (Object)this.getConfigDictById("bankCode").getData());
    }

    @Override
    public Result getConfigDictById(String codeTypes) {
        List strs = StrSpliter.split((String)codeTypes, (String)",", (int)0, (boolean)true, (boolean)true);
        HashMap retrunMap = Maps.newHashMap();
        if (strs.size() > 0) {
            for (String codeType : strs) {
                ArrayList<ConfigDictDto> configDictList = new ArrayList<ConfigDictDto>();
                List<SysDictData> dictList = this.sysDictTypeService.selectDictDataByType(codeType);
                ConfigDictDto dictDto = null;
                for (SysDictData dictData : dictList) {
                    dictDto = new ConfigDictDto();
                    dictDto.setCodeType(dictData.getDictType());
                    dictDto.setCodeValue(dictData.getDictValue());
                    dictDto.setLabel(dictData.getDictLabel());
                    configDictList.add(dictDto);
                }
                retrunMap.put(codeType, configDictList);
            }
        }
        return Result.success((String)"", (Object)retrunMap);
    }

    @Override
    public Result getConfigIndustryDictByComId(ConfigIndustryDict cid) {
        if (StringUtils.isNotEmpty((String)cid.getCodeType())) {
            List<Map> listMap = null;
            if (cid.getComId() != null) {
                listMap = this.configIndustryDictMapper.getConfigIndustryDictByType(cid.getCodeType(), cid.getComId());
            } else if (StringUtils.isNotEmpty((String)cid.getIndustryType()) && StringUtils.isNotEmpty((String)cid.getInstitutionType())) {
                listMap = this.configIndustryDictMapper.getConfigIndustryDictByThisType(cid.getCodeType(), cid.getIndustryType(), cid.getInstitutionType());
            } else {
                return Result.fail((String)"\u884c\u4e1a\u3001\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return Result.success((String)"", listMap);
        }
        return Result.fail((String)"\u4ece\u4e1akey\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    public Result getInstitutionTypeByIndustryType(String industryType) {
        if (StringUtils.isNotEmpty((String)industryType)) {
            List<Map> listMap = this.configIndustryDictMapper.getInstitutionTypeByIndustryType(industryType);
            return Result.success((String)"", listMap);
        }
        return Result.fail((String)"\u884c\u4e1a\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    public Result getInsProjects() {
        List<Map> list = this.configDictMapper.getInsProjects();
        return Result.success((String)"", list);
    }

    @Override
    public Map<String, String> getConfigBdp(String key) {
        String redisKey = this.redisUtil.REDIS_PREFIX_KEY + ":ConfigBdp";
        HashMap cacheMap = Maps.newHashMap();
        Object value = null;
        if (!this.stringRedisTemplate.hasKey((Object)redisKey).booleanValue()) {
            List<Map<String, Object>> list = this.configMapper.getConfigBdp();
            for (Map<String, Object> m : list) {
                cacheMap.put(String.valueOf(m.get("code")), com.alibaba.fastjson.JSONObject.toJSONString(m));
            }
            this.stringRedisTemplate.opsForHash().putAll((Object)redisKey, (Map)cacheMap);
            this.stringRedisTemplate.expire((Object)redisKey, 604800000L, TimeUnit.MILLISECONDS);
            value = cacheMap.get(key);
        } else {
            value = this.stringRedisTemplate.opsForHash().get((Object)redisKey, (Object)key);
        }
        if (value == null) {
            return null;
        }
        return (Map)com.alibaba.fastjson.JSONObject.parseObject((String)String.valueOf(value), Map.class);
    }

    @Override
    public Result deleteRedisByKey(String key) {
        String redisKey = this.redisUtil.REDIS_PREFIX_KEY + ":" + key;
        if (this.stringRedisTemplate.hasKey((Object)redisKey).booleanValue()) {
            this.stringRedisTemplate.delete((Object)redisKey);
        }
        return Result.success((String)"");
    }

    @Override
    public String sendCode(String mobile) {
        String msgMaxCount;
        int phoneCount;
        if (StringUtils.isEmpty((String)mobile)) {
            throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String channel = null;
        if (mobile.length() != PHONE_LENGTH.intValue()) {
            String newMobile = this.perBaseInfoMapper.getMobilePhoneByUserName(mobile);
            if (StringUtil.isEmpty((String)newMobile)) {
                throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            mobile = newMobile;
        }
        if ((phoneCount = this.getSMSPhoneCount(mobile)) >= Integer.parseInt(msgMaxCount = this.sysConfigService.selectConfigByKey("MSG_ONEDAY_MAXCOUNT"))) {
            throw new V5BusinessException("-1", "\u5df2\u8d85\u51fa\u6bcf\u65e5\u9a8c\u8bc1\u7801\u53d1\u9001\u9650\u989d\uff0c\u624b\u673a\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25");
        }
        String random = RandomUtil.randomNumbers((int)6);
        String platform = this.sysConfigService.selectConfigByKey("PLATFORM_SIGN");
        if (!Objects.equals(platform, "PASP-QY")) {
            random = "123456";
        }
        String message = "\u5c0a\u656c\u7684\u5ba2\u6237\uff0c\u4f60\u7684\u6821\u9a8c\u7801\u4e3a{random}\uff0c\u5de5\u4f5c\u4eba\u5458\u4e0d\u4f1a\u7d22\u53d6\u6b64\u9a8c\u8bc1\u7801\uff0c\u8bf7\u52ff\u6cc4\u9732\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u81f4\u75354006629696\u54a8\u8be2".replace("{random}", random);
        String msgOpenState = this.sysConfigService.selectConfigByKey("MSG_OPEN_STATE");
        if (StringUtils.isNotEmpty((String)msgOpenState)) {
            this.setPhoneAuthCode(mobile, random);
            this.sysSmsLogMapper.insert(new SysSmsLog(this.idWorker.nextId(), new Date(), mobile, message));
            if ("1".equals(msgOpenState)) {
                HuaWeiSmsContent huaWeiSmsContent = new HuaWeiSmsContent();
                huaWeiSmsContent.setPlatform("PASP");
                huaWeiSmsContent.setSmsCode("P01");
                huaWeiSmsContent.setMobile(mobile);
                huaWeiSmsContent.setChannel(channel);
                huaWeiSmsContent.setParams(JSON.toJSONString((Object)new String[]{random}));
                SMSUtil.sendHuaWeiSMS(huaWeiSmsContent);
                this.setSMSPhoneCount(mobile, phoneCount);
            }
        }
        return random;
    }

    @Override
    public Result sendVerificationCode(String mobile) {
        this.sendCode(mobile);
        return Result.success((String)"\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
    }

    @Override
    public Result verificationCode(String mobile, String code) {
        String verify;
        if (StringUtils.isEmpty((String)mobile)) {
            throw new V5BusinessException("-1", "\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)code)) {
            throw new V5BusinessException("-1", "\u9a8c\u8bc1\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mobile.length() != PHONE_LENGTH.intValue()) {
            String newMobile = this.perBaseInfoMapper.getMobilePhoneByUserName(mobile);
            if (StringUtil.isEmpty((String)newMobile)) {
                return Result.fail((String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object)mobile);
            }
            mobile = newMobile;
        }
        if (StringUtils.isEmpty((String)(verify = this.getPhoneAuthCode(mobile, code)))) {
            throw new V5BusinessException("-1", "\u60a8\u8f93\u5165\u7684\u9a8c\u8bc1\u7801\u8d85\u65f6\u6216\u8005\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
        }
        if (verify.equals(code)) {
            return Result.success((String)"", null);
        }
        throw new V5BusinessException("-1", "\u60a8\u8f93\u5165\u7684\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
    }

    @Override
    public Result sendBatchSMS(List<Map<String, String>> list, String smsCode) {
        new Thread(() -> {
            String msgOpenState;
            if (list != null && list.size() > 0 && StringUtils.isNotEmpty((String)(msgOpenState = this.commonService.getSystemConfig("MSG_OPEN_STATE")))) {
                try {
                    for (Map map : list) {
                        String mobile = (String)map.get("mobile");
                        String content = (String)map.get("content");
                        String params = (String)map.get("params");
                        if (StringUtils.isEmpty((String)mobile)) {
                            logger.error("\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                            continue;
                        }
                        if (StringUtils.isEmpty((String)content)) {
                            logger.error("\u53d1\u9001\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                            continue;
                        }
                        String channel = (String)map.get("channel");
                        this.sysSmsLogMapper.insert(new SysSmsLog(this.idWorker.nextId(), new Date(), mobile, content));
                        if (!"1".equals(msgOpenState)) continue;
                        HuaWeiSmsContent huaWeiSmsContent = new HuaWeiSmsContent();
                        huaWeiSmsContent.setPlatform("PASP");
                        huaWeiSmsContent.setSmsCode(smsCode);
                        huaWeiSmsContent.setMobile(mobile);
                        huaWeiSmsContent.setParams(params);
                        huaWeiSmsContent.setChannel(channel);
                        SMSUtil.sendHuaWeiSMS(huaWeiSmsContent);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }).start();
        return Result.success((String)"\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
    }

    @Override
    public void sendSMS(HuaWeiSmsContent huaWeiSmsContent) {
        String msgOpenState = this.commonService.getSystemConfig("MSG_OPEN_STATE");
        if ("1".equals(msgOpenState)) {
            SMSUtil.sendHuaWeiSMS(huaWeiSmsContent);
        }
    }

    private void setSMSPhoneCount(String key, int count) {
        if (count == 0) {
            this.stringRedisTemplate.opsForValue().set((Object)("ARS-PASP:PhoneCount:" + key), (Object)(count + 1 + ""), 86400000L, TimeUnit.MILLISECONDS);
        } else {
            this.stringRedisTemplate.opsForValue().set((Object)("ARS-PASP:PhoneCount:" + key), (Object)(count + 1 + ""), 0L);
        }
    }

    private int getSMSPhoneCount(String key) {
        String count = (String)this.stringRedisTemplate.opsForValue().get((Object)("ARS-PASP:PhoneCount:" + key));
        if (StringUtils.isEmpty((String)count)) {
            return 0;
        }
        return Integer.parseInt(count);
    }

    private String getPhoneAuthCode(String key, String value) {
        if (value.equalsIgnoreCase("888888")) {
            return value;
        }
        String result = (String)this.stringRedisTemplate.opsForValue().get((Object)("ARS-PASP:PhoneAuthCode:" + key + value));
        return result;
    }

    private void setPhoneAuthCode(String key, String value) {
        this.stringRedisTemplate.opsForValue().set((Object)("ARS-PASP:PhoneAuthCode:" + key + value), (Object)value, 600000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void sendEmailMessage(String tilte, String content, String messageType, String emails) {
        new Thread(() -> {
            try {
                HashMap params = CollUtil.newHashMap();
                params.put("title", tilte);
                params.put("content", content);
                params.put("messageType", messageType);
                params.put("emails", emails);
                params.put("platId", "10");
                String result = HttpUtils.doPost(this.sysConfigService.selectConfigByKey("SYS_PIC_HTTP_ADDR") + "/public/message/send-email-message", params);
                logger.info(result);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }).start();
    }

    @Override
    public String getComManageHuaweiMeetAccessToken(String userName, String passWord, String comId) {
        String redisKey = "ARS-PASP:huaweiMeetCom" + comId;
        String accessToken = "";
        if (!this.stringRedisTemplate.hasKey((Object)redisKey).booleanValue()) {
            Map resultMap;
            String authorization = Base64.getEncoder().encodeToString((userName + ":" + passWord).getBytes());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("account", userName);
            map.put("clientType", 0);
            map.put("createTokenType", 0);
            String url = "https://api.meeting.huaweicloud.com/v1/usg/acs/auth/account";
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("Authorization", "Basic " + authorization);
            RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, JSON.toJSONString(map), null);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            if (response.getHttpCode() == 200 && (resultMap = (Map)JSON.parseObject((String)response.getEntity().toString(), Map.class)) != null) {
                accessToken = resultMap.get("accessToken").toString();
                String expires_in = resultMap.get("validPeriod").toString();
                Long expiresTime = Long.parseLong(expires_in) - 3600L;
                if (expiresTime > 0L) {
                    this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)accessToken, expiresTime.longValue(), TimeUnit.SECONDS);
                }
            }
        } else {
            accessToken = (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
            logger.info("\u4ece\u7f13\u5b58\u4e2d\u62ffaccessToken:" + accessToken);
        }
        return accessToken;
    }

    @Override
    public String getHuaweiMeetIAMTokens(Long comId) {
        String redisKey = "ARS-PASP:huaweiMeetIAM" + comId;
        String accessToken = "";
        if (!this.stringRedisTemplate.hasKey((Object)redisKey).booleanValue()) {
            String url = "https://iam.myhuaweicloud.com/v3/auth/tokens";
            String param = "{\"auth\":{\"identity\":{\"methods\":[\"password\"],\"password\":{\"user\":{\"domain\":{\"name\":\"IAMDomain\"},\"name\":\"IAMUser\",\"password\":\"IAMPassword\"}}},\"scope\":{\"project\":{\"name\":\"IAMproject\"}}}}".replace("IAMUser", this.getSystemConfig("MEET_LOGIN_USER")).replace("IAMproject", this.getSystemConfig("MEET_ACTUATING_RANGE_4")).replace("IAMDomain", this.getSystemConfig("MEET_LOGIN_USER")).replace("IAMPassword", this.getSystemConfig("MEET_LOGIN_PWD"));
            accessToken = HttpUtil.postGetToken(url, param);
            if (StringUtils.isNotEmpty((String)accessToken)) {
                this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)accessToken, 86400000L, TimeUnit.MILLISECONDS);
            }
        } else {
            accessToken = (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
            logger.info("\u4ece\u7f13\u5b58\u4e2d\u62ffaccessToken:" + accessToken);
        }
        return accessToken;
    }

    @Override
    public List<ConfigBankOutletsDTO> getConfigBankOutlets() {
        String redisKey = "ARS-PASP:configBankOutlets";
        String bankListStr = "";
        if (!this.stringRedisTemplate.hasKey((Object)redisKey).booleanValue()) {
            List<ConfigBankOutletsDTO> bankList = this.configBankOutletsMapper.getBankOutletsList();
            bankListStr = JSON.toJSONString(bankList);
            this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)bankListStr, 604800L, TimeUnit.SECONDS);
        } else {
            bankListStr = (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
        }
        List<ConfigBankOutletsDTO> banklist = new ArrayList<ConfigBankOutletsDTO>();
        if (StringUtils.isNotEmpty((String)bankListStr)) {
            banklist = JSON.parseArray((String)bankListStr, ConfigBankOutletsDTO.class);
        }
        return banklist;
    }
}

