/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.Attend;
import com.bcxin.platform.domain.attend.AttendPer;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.dto.app.AppAttendPerDto;
import com.bcxin.platform.dto.attend.AttendPerDto;
import com.bcxin.platform.mapper.attend.AttendMapper;
import com.bcxin.platform.mapper.attend.AttendPerMapper;
import com.bcxin.platform.mapper.attend.AttendSchedulDetailMapper;
import com.bcxin.platform.service.attend.AttendPerService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class AttendPerServiceImpl
implements AttendPerService {
    @Autowired
    private AttendMapper attendMapper;
    @Autowired
    private AttendPerMapper attendPerMapper;
    @Autowired
    private AttendSchedulDetailMapper attendSchedulMapper;
    @Resource
    private IdWorker idWorker;

    @Override
    public AttendPer findById(Long id) {
        return this.attendPerMapper.findById(id);
    }

    @Override
    public List<AttendPerDto> selectList(AttendPerDto attendPer) {
        return this.attendPerMapper.selectList(attendPer);
    }

    @Override
    public int update(AttendPer attendPer) {
        Attend attend = this.attendMapper.findById(attendPer.getAttendId());
        if (attend == null) {
            throw new BusinessException("\u8003\u52e4\u5957id\u9519\u8bef\uff0c\u5bf9\u5e94\u8003\u52e4\u5957\u4e0d\u5b58\u5728\uff01");
        }
        if ("0".equals(attend.getActive())) {
            throw new BusinessException("\u8003\u52e4\u5957\u672a\u542f\u7528\uff01");
        }
        if ("1".equals(attend.getIsDelete())) {
            throw new BusinessException("\u8003\u52e4\u5957\u5df2\u5220\u9664\uff01");
        }
        AttendPer checkAttendPer = this.attendPerMapper.findByPerId(attendPer.getPerId());
        if (checkAttendPer != null && !checkAttendPer.getId().equals(attendPer.getId())) {
            throw new BusinessException("\u8be5\u4fdd\u5b89\u5458\u5df2\u7ef4\u62a4\u8003\u52e4\u5957\uff0c\u8bf7\u52ff\u91cd\u590d\u7ef4\u62a4\uff01");
        }
        if (attendPer.getId() == null) {
            attendPer.setCreateTime(DateUtils.getNowDate());
            attendPer.setId(this.idWorker.nextId());
            attendPer.setIsDelete("0");
        } else {
            AttendPer dbAttendPer = this.attendPerMapper.findById(attendPer.getId());
            if (dbAttendPer.getAttendId().longValue() == attendPer.getAttendId().longValue()) {
                throw new BusinessException("\u8003\u52e4\u5957\u6ca1\u6709\u53d8\u66f4\uff0c\u65e0\u9700\u64cd\u4f5c\u4fdd\u5b58");
            }
            dbAttendPer.setUpdateTime(DateUtils.getNowDate());
            this.attendPerMapper.removeSchedul(dbAttendPer);
            BeanUtils.copyPropertiesIgnore((Object)attendPer, (Object)dbAttendPer, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbAttendPer, (Object)attendPer, (Boolean)false);
        }
        attendPer.setUpdateTime(DateUtils.getNowDate());
        return this.attendPerMapper.save(attendPer);
    }

    @Override
    public int deleteByIds(String ids) {
        this.attendSchedulMapper.removeByPerIds(Convert.toStrArray((String)ids));
        return this.attendPerMapper.deleteByIds(Convert.toStrArray((String)ids));
    }

    @Override
    public List<PerBaseInfo> getDepartPersonList(AttendPerDto searchDto) {
        if (!(searchDto.isDomainAdmin() || searchDto.getAdminDepartIds() != null && searchDto.getAdminDepartIds().size() != 0)) {
            return new ArrayList<PerBaseInfo>();
        }
        return this.attendPerMapper.getDepartPersonList(searchDto);
    }

    @Override
    public List<AppAttendPerDto> selectListForPer(AppAttendPerDto perDto) {
        return this.attendPerMapper.selectListForPer(perDto);
    }

    @Override
    public int save(AttendPer attendPer) throws CloneNotSupportedException {
        Attend attend = this.attendMapper.findById(attendPer.getAttendId());
        if (attend == null) {
            throw new BusinessException("\u8003\u52e4\u5957id\u9519\u8bef\uff0c\u5bf9\u5e94\u8003\u52e4\u5957\u4e0d\u5b58\u5728\uff01");
        }
        if ("0".equals(attend.getActive())) {
            throw new BusinessException("\u8003\u52e4\u5957\u672a\u542f\u7528\uff01");
        }
        if ("1".equals(attend.getIsDelete())) {
            throw new BusinessException("\u8003\u52e4\u5957\u5df2\u5220\u9664\uff01");
        }
        attendPer.setCreateTime(DateUtils.getNowDate());
        attendPer.setUpdateTime(DateUtils.getNowDate());
        attendPer.setIsDelete("0");
        ArrayList<AttendPer> perList = new ArrayList<AttendPer>();
        for (Long perId : attendPer.getPerIds()) {
            AttendPer addAttendPer = attendPer.clone();
            addAttendPer.setId(this.idWorker.nextId());
            addAttendPer.setPerId(perId);
            perList.add(addAttendPer);
        }
        List<PerBaseInfo> dbAttendPerList = this.attendPerMapper.findByBatchPerId(perList);
        if (dbAttendPerList != null && dbAttendPerList.size() > 0) {
            String perNames = dbAttendPerList.stream().map(PerBaseInfo::getName).collect(Collectors.toList()).stream().collect(Collectors.joining(", "));
            throw new BusinessException("\u4fdd\u5b89\u5458(" + perNames + ")\u5df2\u7ef4\u62a4\u8003\u52e4\u5957\uff0c\u8bf7\u52ff\u91cd\u590d\u7ef4\u62a4\uff01");
        }
        return this.attendPerMapper.saveBatch(perList);
    }

    @Override
    public List<AppAttendPerDto> getUnSchedulPersonList(AppAttendPerDto perDto) {
        return this.attendPerMapper.getUnSchedulPersonList(perDto);
    }

    @Override
    public int deleteByPerIds(AppAttendPerDto attendPerDto) {
        this.attendSchedulMapper.deleteByPerIds(attendPerDto);
        return this.attendPerMapper.deleteByPerIds(attendPerDto);
    }
}

