/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.meeting;

import cn.hutool.core.text.StrSpliter;
import com.alibaba.fastjson.JSON;
import com.bcxin.platform.common.exception.PlatFormBusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.domain.meeting.ComHuaweiMeetMatch;
import com.bcxin.platform.domain.meeting.PerHuaweiMeetMatch;
import com.bcxin.platform.dto.meeting.PerHuaweiMeetMatchDto;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.mapper.meeting.ComHuaweiMeetMatchMapper;
import com.bcxin.platform.mapper.meeting.PerHuaweiMeetMatchMapper;
import com.bcxin.platform.service.cache.TaskCacheService;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.meeting.PerHuaweiMeetMatchService;
import com.bcxin.platform.util.DateUtils;
import com.bcxin.platform.util.huawei.HttpBuildUtil;
import com.bcxin.platform.util.huawei.RestRequest;
import com.bcxin.platform.util.huawei.RestResponse;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="transactionManager")
public class PerHuaweiMeetMatchServiceImpl
implements PerHuaweiMeetMatchService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private PerHuaweiMeetMatchMapper perHuaweiMeetMatchMapper;
    @Resource
    private ComHuaweiMeetMatchMapper comHuaweiMeetMatchMapper;
    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;
    @Resource
    private TaskCacheService taskCacheService;
    @Resource
    private CommonService commonService;

    @Override
    public Result getHuaweiAccessToken(PerHuaweiMeetMatch perHuaweiMeetMatch) throws PlatFormBusinessException {
        PerHuaweiMeetMatch meetMatch = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerId(perHuaweiMeetMatch.getPerId());
        if (meetMatch == null) {
            return Result.fail((String)"\u4f01\u4e1a\u7ba1\u7406\u5458\u8fd8\u672a\u628a\u60a8\u6dfb\u52a0\u5230\u4f1a\u8bae\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u60a8\u6240\u5728\u4f01\u4e1a\u7ba1\u7406\u5458\u6dfb\u52a0");
        }
        String accessToken = this.taskCacheService.getHuaweiMeetAccessToken(meetMatch.getHuaweiUserName(), meetMatch.getHuaweiPassWord(), perHuaweiMeetMatch.getPerId());
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("huaweiUserName", meetMatch.getHuaweiUserName());
        resultMap.put("huaweiPassWord", meetMatch.getHuaweiPassWord());
        resultMap.put("huaweiUserId", meetMatch.getHuaweiUserId());
        resultMap.put("huaweiSipName", meetMatch.getHuaweiSipName());
        resultMap.put("accessToken", accessToken);
        return Result.success((String)"", resultMap);
    }

    @Override
    public Result addUser(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException {
        if (dto.getPerId() == null) {
            return Result.fail((String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PerHuaweiMeetMatch perHuaweiMeetMatch = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerId(dto.getPerId());
        if (perHuaweiMeetMatch != null) {
            return Result.fail((String)"\u6b64\u4eba\u5df2\u6709\u4f1a\u8bae\u6743\u9650\uff0c\u65e0\u9700\u91cd\u590d\u6dfb\u52a0");
        }
        ComHuaweiMeetMatch comHuaweiMeetMatch = this.comHuaweiMeetMatchMapper.getComHuaweiMeetMatchByComId(dto.getComId());
        if (comHuaweiMeetMatch == null) {
            return Result.fail((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6240\u5728\u7684\u4f01\u4e1a\u4e0d\u5b58\u5728\u4f1a\u8bae\u4f7f\u7528\u6743\u9650");
        }
        String accessToken = this.taskCacheService.getComManageHuaweiMeetAccessToken(comHuaweiMeetMatch.getHuaweiManageUserName(), comHuaweiMeetMatch.getHuaweiManagePassWord(), dto.getComId());
        dto.setHuaweiUserName("user" + dto.getPerId());
        dto.setHuaweiPassWord("pwd" + dto.getPerId().toString().substring(dto.getPerId().toString().length() - 6));
        PerBaseInfo perBaseInfo = new PerBaseInfo();
        perBaseInfo.setPerId(dto.getPerId());
        perBaseInfo = this.perBaseInfoMapper.selectPerBaseInfoById(perBaseInfo.getPerId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", perBaseInfo.getName());
        map.put("account", dto.getHuaweiUserName());
        map.put("pwd", dto.getHuaweiPassWord());
        map.put("phone", perBaseInfo.getMobilePhone());
        map.put("sendNotify", "0");
        map.put("country", "chinaPR");
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/corp/member";
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, JSON.toJSONString(map), null);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        Map<String, Object> resultMap = HttpBuildUtil.getMapData(response);
        dto.setHuaweiUserId(resultMap.get("id").toString());
        dto.setHuaweiSipName(resultMap.get("sipNum").toString());
        this.perHuaweiMeetMatchMapper.insertPerHuaweiMeetMatch(dto);
        return Result.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @Override
    public Result setRegulatorMeetCharge(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException {
        if (dto.getPerId() == null) {
            return Result.fail((String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PerHuaweiMeetMatch perHuaweiMeetMatch = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerId(dto.getPerId());
        if (perHuaweiMeetMatch == null) {
            return Result.fail((String)"\u672a\u67e5\u627e\u5230\u4eba\u5458\u6d88\u606f");
        }
        perHuaweiMeetMatch.setRegulatorMeetChargeType(dto.getRegulatorMeetChargeType());
        this.perHuaweiMeetMatchMapper.updatePerHuaweiMeetMatch(perHuaweiMeetMatch);
        return Result.success((String)"\u8bbe\u7f6e\u6210\u529f");
    }

    @Override
    public Result cancelRegulatorMeetCharge(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException {
        if (dto.getPerId() == null) {
            return Result.fail((String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PerHuaweiMeetMatch perHuaweiMeetMatch = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerId(dto.getPerId());
        if (perHuaweiMeetMatch == null) {
            return Result.fail((String)"\u672a\u67e5\u627e\u5230\u4eba\u5458\u6d88\u606f");
        }
        perHuaweiMeetMatch.setRegulatorMeetChargeType("0");
        this.perHuaweiMeetMatchMapper.updatePerHuaweiMeetMatch(perHuaweiMeetMatch);
        return Result.success((String)"\u53d6\u6d88\u6210\u529f");
    }

    @Override
    public Result batchDeleteUser(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException {
        if (StringUtils.isEmpty((String)dto.getPerIds())) {
            return Result.fail((String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List perIdList = StrSpliter.split((String)dto.getPerIds(), (String)",", (int)0, (boolean)true, (boolean)true);
        List<PerHuaweiMeetMatch> list = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerIdList(perIdList);
        if (list != null && list.size() > 0) {
            ArrayList<String> huaweiUserNameList = new ArrayList<String>();
            ArrayList<Long> existsPerIdList = new ArrayList<Long>();
            for (PerHuaweiMeetMatch perHuaweiMeetMatch : list) {
                huaweiUserNameList.add(perHuaweiMeetMatch.getHuaweiUserName());
                existsPerIdList.add(perHuaweiMeetMatch.getPerId());
            }
            ComHuaweiMeetMatch comHuaweiMeetMatch = this.comHuaweiMeetMatchMapper.getComHuaweiMeetMatchByComId(dto.getComId());
            if (comHuaweiMeetMatch == null) {
                return Result.fail((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6240\u5728\u7684\u4f01\u4e1a\u4e0d\u5b58\u5728\u4f1a\u8bae\u4f7f\u7528\u6743\u9650");
            }
            String accessToken = this.taskCacheService.getComManageHuaweiMeetAccessToken(comHuaweiMeetMatch.getHuaweiManageUserName(), comHuaweiMeetMatch.getHuaweiManagePassWord(), dto.getComId());
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("X-Access-Token", accessToken);
            String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/corp/member/delete";
            RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, JSON.toJSONString(huaweiUserNameList), null);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            String resultMsg = HttpBuildUtil.failMsg(response);
            if (StringUtils.isNotEmpty((String)resultMsg)) {
                return Result.fail((String)resultMsg);
            }
            this.perHuaweiMeetMatchMapper.batchDeletePerHuaweiMeetMatch(existsPerIdList);
            return Result.success((String)"\u5220\u9664\u6210\u529f");
        }
        return Result.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public Result leaveJonBatchDeleteUser(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException {
        List<PerHuaweiMeetMatch> list;
        if (StringUtils.isEmpty((String)dto.getPerIds())) {
            return Result.fail((String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List perIdList = StrSpliter.split((String)dto.getPerIds(), (String)",", (int)0, (boolean)true, (boolean)true);
        ComHuaweiMeetMatch comHuaweiMeetMatch = this.comHuaweiMeetMatchMapper.getComHuaweiMeetMatchByComId(dto.getComId());
        if (comHuaweiMeetMatch != null && (list = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerIdList(perIdList)) != null && list.size() > 0) {
            ArrayList<String> huaweiUserNameList = new ArrayList<String>();
            ArrayList<Long> existsPerIdList = new ArrayList<Long>();
            for (PerHuaweiMeetMatch perHuaweiMeetMatch : list) {
                huaweiUserNameList.add(perHuaweiMeetMatch.getHuaweiUserName());
                existsPerIdList.add(perHuaweiMeetMatch.getPerId());
            }
            String accessToken = this.taskCacheService.getComManageHuaweiMeetAccessToken(comHuaweiMeetMatch.getHuaweiManageUserName(), comHuaweiMeetMatch.getHuaweiManagePassWord(), dto.getComId());
            HashMap<String, String> headMap = new HashMap<String, String>();
            headMap.put("X-Access-Token", accessToken);
            String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/corp/member/delete";
            RestRequest restRequest = HttpBuildUtil.buildRestRequest("POST", headMap, JSON.toJSONString(huaweiUserNameList), null);
            RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
            String resultMsg = HttpBuildUtil.failMsg(response);
            if (StringUtils.isNotEmpty((String)resultMsg)) {
                return Result.fail((String)resultMsg);
            }
            this.perHuaweiMeetMatchMapper.batchDeletePerHuaweiMeetMatch(existsPerIdList);
        }
        return Result.success((String)"");
    }

    @Override
    public Result getHuaweiMeetList(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException {
        if (dto.getPerId() == null) {
            return Result.fail((String)"\u4eba\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageNumber() == null) {
            return Result.fail((String)"\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            return Result.fail((String)"\u6bcf\u9875\u591a\u5c11\u6761\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PerHuaweiMeetMatch meetMatch = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerId(dto.getPerId());
        if (meetMatch == null) {
            return Result.fail((String)"\u4f01\u4e1a\u7ba1\u7406\u5458\u8fd8\u672a\u628a\u60a8\u6dfb\u52a0\u5230\u4f1a\u8bae\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u60a8\u6240\u5728\u4f01\u4e1a\u7ba1\u7406\u5458\u6dfb\u52a0");
        }
        String accessToken = this.taskCacheService.getHuaweiMeetAccessToken(meetMatch.getHuaweiUserName(), meetMatch.getHuaweiPassWord(), meetMatch.getPerId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userUUID", meetMatch.getHuaweiUserId());
        Integer offset = (dto.getPageNumber() - 1) * dto.getPageSize();
        map.put("offset", offset.toString());
        map.put("limit", dto.getPageSize().toString());
        map.put("sortType", "DSC_StartTIME");
        if (StringUtil.isNotEmpty((String)dto.getKeyWord())) {
            map.put("searchKey", dto.getKeyWord());
        }
        if (StringUtil.isNotEmpty((String)dto.getQueryConfMode())) {
            map.put("queryConfMode", dto.getQueryConfMode());
        }
        String url = "https://api.meeting.huaweicloud.com/v1/mmc/management/conferences";
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, map);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"", HttpBuildUtil.getMapData(response));
    }

    @Override
    public Result sendHuaweiMeetSms(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException {
        if (StringUtils.isEmpty((String)dto.getPhones())) {
            return Result.fail((String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List phoneList = StrSpliter.split((String)dto.getPhones(), (String)",", (int)0, (boolean)true, (boolean)true);
        ArrayList mList = Lists.newArrayList();
        String content = "\u3010\u767e\u4fdd\u76fe\u3011\u4f1a\u8bae\u901a\u77e5\uff1a\u60a8\u7684[{meetTheme}]\u5c06\u5728[{meetStartTime}]\u5f00\u59cb\uff0c\u8bf7\u60a8\u51c6\u65f6\u53c2\u52a0\u3002\u4f1a\u8baeID\uff1a[{meetId}]\uff0c\u6765\u5bbe\u5bc6\u7801\uff1a[{guestPwd}]\uff0c\u4e3b\u6301\u4eba\u5bc6\u7801\uff1a[{chairPwd}]\u3002\u786c\u7ec8\u7aef\u63a5\u5165\u8bf7\u62e8\u6253\uff1a[{meetId}]\uff0c\u8bf7\u4f7f\u7528App\u6216\u8005PC\u7684\u4f1a\u8bae\u529f\u80fd\u586b\u5165\u76f8\u5173\u4f1a\u8baeID\u4e0e\u5bc6\u7801\u53c2\u52a0\u4f1a\u8bae\u3002".replace("{meetTheme}", dto.getMeetTheme()).replace("{meetStartTime}", dto.getMeetStartTime()).replace("{meetId}", dto.getMeetId()).replace("{guestPwd}", dto.getGuestPwd()).replace("{chairPwd}", dto.getChairPwd());
        for (String mobile : phoneList) {
            HashMap map = Maps.newHashMap();
            map.put("mobile", mobile);
            map.put("content", content);
            map.put("params", JSON.toJSONString((Object)new String[]{dto.getMeetTheme(), dto.getMeetStartTime(), dto.getMeetId(), dto.getGuestPwd(), dto.getChairPwd(), dto.getMeetId()}));
            mList.add(map);
        }
        if (mList.size() > 0) {
            this.commonService.sendBatchSMS(mList, "B11");
        }
        return Result.success((String)"");
    }

    @Override
    public Result getTranscribeFileList(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException {
        if (dto.getPageNumber() == null) {
            return Result.fail((String)"\u7b2c\u51e0\u9875\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPageSize() == null) {
            return Result.fail((String)"\u6bcf\u9875\u591a\u5c11\u6761\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getStartTime())) {
            return Result.fail((String)"\u67e5\u8be2\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getEndTime())) {
            return Result.fail((String)"\u67e5\u8be2\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = DateUtils.parseDate((String)(dto.getStartTime() + " 00:00:00"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
            endTime = DateUtils.parseDate((String)(dto.getEndTime() + " 23:59:59"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        }
        catch (Exception exception) {
            // empty catch block
        }
        PerHuaweiMeetMatch meetMatch = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerId(dto.getPerId());
        if (meetMatch == null) {
            return Result.fail((String)"\u4f01\u4e1a\u7ba1\u7406\u5458\u8fd8\u672a\u628a\u60a8\u6dfb\u52a0\u5230\u4f1a\u8bae\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u60a8\u6240\u5728\u4f01\u4e1a\u7ba1\u7406\u5458\u6dfb\u52a0");
        }
        String accessToken = this.taskCacheService.getHuaweiMeetAccessToken(meetMatch.getHuaweiUserName(), meetMatch.getHuaweiPassWord(), meetMatch.getPerId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userUUID", meetMatch.getHuaweiUserId());
        map.put("offset", String.valueOf(dto.getPageNumber() - 1));
        map.put("limit", dto.getPageSize().toString());
        if (StringUtils.isNotEmpty((String)dto.getMeetTheme())) {
            map.put("searchKey", dto.getMeetTheme());
        }
        map.put("startDate", String.valueOf(startTime.getTime()));
        map.put("endDate", String.valueOf(endTime.getTime()));
        map.put("sortType", "DSC_StartTIME");
        String url = "https://api.meeting.huaweicloud.com/v1/mmc/management/record/files";
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, map);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"", HttpBuildUtil.getMapData(response));
    }

    @Override
    public Result batchDeleteTranscribeFile(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException {
        if (StringUtils.isEmpty((String)dto.getConfUUIDs())) {
            return Result.fail((String)"\u4f1a\u8baeUUID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PerHuaweiMeetMatch meetMatch = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerId(dto.getPerId());
        if (meetMatch == null) {
            return Result.fail((String)"\u4f01\u4e1a\u7ba1\u7406\u5458\u8fd8\u672a\u628a\u60a8\u6dfb\u52a0\u5230\u4f1a\u8bae\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u60a8\u6240\u5728\u4f01\u4e1a\u7ba1\u7406\u5458\u6dfb\u52a0");
        }
        String accessToken = this.taskCacheService.getHuaweiMeetAccessToken(meetMatch.getHuaweiUserName(), meetMatch.getHuaweiPassWord(), meetMatch.getPerId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("confUUIDs", dto.getConfUUIDs());
        String url = "https://api.meeting.huaweicloud.com/v1/mmc/management/record/files";
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("DELETE", headMap, null, map);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Override
    public Result getHuaweiMeetDetail(PerHuaweiMeetMatchDto dto) throws PlatFormBusinessException {
        if (StringUtils.isEmpty((String)dto.getConferenceId())) {
            return Result.fail((String)"\u4f1a\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PerHuaweiMeetMatch meetMatch = this.perHuaweiMeetMatchMapper.getPerHuaweiMeetMatchByPerId(dto.getPerId());
        if (meetMatch == null) {
            return Result.fail((String)"\u4f01\u4e1a\u7ba1\u7406\u5458\u8fd8\u672a\u628a\u60a8\u6dfb\u52a0\u5230\u4f1a\u8bae\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u60a8\u6240\u5728\u4f01\u4e1a\u7ba1\u7406\u5458\u6dfb\u52a0");
        }
        String accessToken = this.taskCacheService.getHuaweiMeetAccessToken(meetMatch.getHuaweiUserName(), meetMatch.getHuaweiPassWord(), meetMatch.getPerId());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("conferenceID", dto.getConferenceId());
        map.put("userUUID", meetMatch.getHuaweiUserId());
        if (dto.getPageNumber() != null && dto.getPageNumber() != 0) {
            Integer offset = (dto.getPageNumber() - 1) * dto.getPageSize();
            map.put("offset", offset.toString());
        }
        if (dto.getPageSize() != null && dto.getPageSize() != 0) {
            map.put("limit", dto.getPageSize().toString());
        }
        if (StringUtil.isNotEmpty((String)dto.getKeyWord())) {
            map.put("searchKey", dto.getKeyWord());
        }
        String url = "https://api.meeting.huaweicloud.com/v1/mmc/management/conferences/confDetail";
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("X-Access-Token", accessToken);
        RestRequest restRequest = HttpBuildUtil.buildRestRequest("GET", headMap, null, map);
        RestResponse response = HttpBuildUtil.sendMsg(url, restRequest);
        String resultMsg = HttpBuildUtil.failMsg(response);
        if (StringUtils.isNotEmpty((String)resultMsg)) {
            return Result.fail((String)resultMsg);
        }
        return Result.success((String)"", HttpBuildUtil.getMapData(response));
    }
}

