"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _invariant = require('@turf/invariant');
var _helpers = require('@turf/helpers');
var _bbox = require('@turf/bbox');
var _explode = require('@turf/explode');
var _nearestpoint = require('@turf/nearest-point');
function polygonTangents(pt, polygon) {
  const pointCoords = _invariant.getCoords.call(void 0, pt);
  const polyCoords = _invariant.getCoords.call(void 0, polygon);
  let rtan = [];
  let ltan = [];
  let eprev;
  const bbox = _bbox.bbox.call(void 0, polygon);
  let nearestPtIndex = 0;
  let nearest = null;
  if (pointCoords[0] > bbox[0] && pointCoords[0] < bbox[2] && pointCoords[1] > bbox[1] && pointCoords[1] < bbox[3]) {
    nearest = _nearestpoint.nearestPoint.call(void 0, pt, _explode.explode.call(void 0, polygon));
    nearestPtIndex = nearest.properties.featureIndex;
  }
  const type = _invariant.getType.call(void 0, polygon);
  switch (type) {
    case "Polygon":
      rtan = polyCoords[0][nearestPtIndex];
      ltan = polyCoords[0][0];
      if (nearest !== null) {
        if (nearest.geometry.coordinates[1] < pointCoords[1])
          ltan = polyCoords[0][nearestPtIndex];
      }
      eprev = isLeft(
        polyCoords[0][0],
        polyCoords[0][polyCoords[0].length - 1],
        pointCoords
      );
      [rtan, ltan] = processPolygon(
        polyCoords[0],
        pointCoords,
        eprev,
        rtan,
        ltan
      );
      break;
    case "MultiPolygon":
      var closestFeature = 0;
      var closestVertex = 0;
      var verticesCounted = 0;
      for (var i = 0; i < polyCoords[0].length; i++) {
        closestFeature = i;
        var verticeFound = false;
        for (var i2 = 0; i2 < polyCoords[0][i].length; i2++) {
          closestVertex = i2;
          if (verticesCounted === nearestPtIndex) {
            verticeFound = true;
            break;
          }
          verticesCounted++;
        }
        if (verticeFound) break;
      }
      rtan = polyCoords[0][closestFeature][closestVertex];
      ltan = polyCoords[0][closestFeature][closestVertex];
      eprev = isLeft(
        polyCoords[0][0][0],
        polyCoords[0][0][polyCoords[0][0].length - 1],
        pointCoords
      );
      polyCoords.forEach(function(ring) {
        [rtan, ltan] = processPolygon(ring[0], pointCoords, eprev, rtan, ltan);
      });
      break;
  }
  return _helpers.featureCollection.call(void 0, [_helpers.point.call(void 0, rtan), _helpers.point.call(void 0, ltan)]);
}
function processPolygon(polygonCoords, ptCoords, eprev, rtan, ltan) {
  for (let i = 0; i < polygonCoords.length; i++) {
    const currentCoords = polygonCoords[i];
    let nextCoordPair = polygonCoords[i + 1];
    if (i === polygonCoords.length - 1) {
      nextCoordPair = polygonCoords[0];
    }
    const enext = isLeft(currentCoords, nextCoordPair, ptCoords);
    if (eprev <= 0 && enext > 0) {
      if (!isBelow(ptCoords, currentCoords, rtan)) {
        rtan = currentCoords;
      }
    } else if (eprev > 0 && enext <= 0) {
      if (!isAbove(ptCoords, currentCoords, ltan)) {
        ltan = currentCoords;
      }
    }
    eprev = enext;
  }
  return [rtan, ltan];
}
function isAbove(point1, point2, point3) {
  return isLeft(point1, point2, point3) > 0;
}
function isBelow(point1, point2, point3) {
  return isLeft(point1, point2, point3) < 0;
}
function isLeft(point1, point2, point3) {
  return (point2[0] - point1[0]) * (point3[1] - point1[1]) - (point3[0] - point1[0]) * (point2[1] - point1[1]);
}
var index_default = polygonTangents;



exports.default = index_default; exports.polygonTangents = polygonTangents;
//# sourceMappingURL=index.cjs.map