"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _area = require('@turf/area');
var _bbox = require('@turf/bbox');
var _bboxpolygon = require('@turf/bbox-polygon');
var _centroid = require('@turf/centroid');
var _distance = require('@turf/distance');
var _nearestpoint = require('@turf/nearest-point');
var _meta = require('@turf/meta');



var _helpers = require('@turf/helpers');
function nearestNeighborAnalysis(dataset, options) {
  options = options || {};
  const studyArea = options.studyArea || _bboxpolygon.bboxPolygon.call(void 0, _bbox.bbox.call(void 0, dataset));
  const properties = options.properties || {};
  const units = options.units || "kilometers";
  const features = [];
  _meta.featureEach.call(void 0, dataset, (feature) => {
    features.push(_centroid.centroid.call(void 0, feature));
  });
  const n = features.length;
  const observedMeanDistance = features.map((feature, index) => {
    const otherFeatures = _helpers.featureCollection.call(void 0, 
      features.filter((f, i) => {
        return i !== index;
      })
    );
    return _distance.distance.call(void 0, 
      feature,
      _nearestpoint.nearestPoint.call(void 0, feature, otherFeatures).geometry.coordinates,
      { units }
    );
  }).reduce((sum, value) => {
    return sum + value;
  }, 0) / n;
  const populationDensity = n / _helpers.convertArea.call(void 0, _area.area.call(void 0, studyArea), "meters", units);
  const expectedMeanDistance = 1 / (2 * Math.sqrt(populationDensity));
  const variance = 0.26136 / Math.sqrt(n * populationDensity);
  properties.nearestNeighborAnalysis = {
    units,
    arealUnits: units + "\xB2",
    observedMeanDistance,
    expectedMeanDistance,
    nearestNeighborIndex: observedMeanDistance / expectedMeanDistance,
    numberOfPoints: n,
    zScore: (observedMeanDistance - expectedMeanDistance) / variance
  };
  studyArea.properties = properties;
  return studyArea;
}
var index_default = nearestNeighborAnalysis;



exports.default = index_default; exports.nearestNeighborAnalysis = nearestNeighborAnalysis;
//# sourceMappingURL=index.cjs.map